/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.serialize;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.serialize.ISerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0011H\u0016R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lnet/jkcode/jkmvc/serialize/FstSerializer;", "Lnet/jkcode/jkmvc/serialize/ISerializer;", "()V", "conf", "Lorg/nustaq/serialization/FSTConfiguration;", "kotlin.jvm.PlatformType", "getConf", "()Lorg/nustaq/serialization/FSTConfiguration;", "putSerializer", "", "cl", "Ljava/lang/Class;", "ser", "Lorg/nustaq/serialization/FSTObjectSerializer;", "includeSubclasses", "", "serialize", "", "obj", "", "unserialize", "input", "Ljava/io/InputStream;", "bytes", "jkmvc-common"})
public final class FstSerializer
implements ISerializer {
    private final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();

    protected final FSTConfiguration getConf() {
        return this.conf;
    }

    public final void putSerializer(@NotNull Class<?> cl, @NotNull FSTObjectSerializer ser, boolean includeSubclasses) {
        Intrinsics.checkParameterIsNotNull(cl, (String)"cl");
        Intrinsics.checkParameterIsNotNull((Object)ser, (String)"ser");
        FSTSerializerRegistry reg = this.conf.getCLInfoRegistry().getSerializerRegistry();
        reg.putSerializer(cl, ser, includeSubclasses);
    }

    @Override
    @Nullable
    public byte[] serialize(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return this.conf.asByteArray(obj);
    }

    @Override
    @Nullable
    public Object unserialize(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return this.conf.getObjectInput(bytes).readObject();
    }

    @Override
    @Nullable
    public Object unserialize(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.conf.getObjectInput(input).readObject();
    }
}

