/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.common.AddressesParser;
import net.jkcode.jkmvc.common.Config;
import net.jkcode.jkmvc.common.IConfig;
import net.jkcode.jkmvc.redis.IJedisFactory;
import net.jkcode.jkmvc.redis.ShardedJedisFactory;
import net.jkcode.jkmvc.ttl.AllRequestScopedTransferableThreadLocal;
import net.jkcode.jkmvc.ttl.ScopedTransferableThreadLocal;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/jkcode/jkmvc/redis/ShardedJedisFactory;", "Lnet/jkcode/jkmvc/redis/IJedisFactory;", "()V", "jedises", "Lnet/jkcode/jkmvc/ttl/AllRequestScopedTransferableThreadLocal;", "Ljava/util/HashMap;", "", "Lredis/clients/jedis/ShardedJedis;", "pools", "Ljava/util/concurrent/ConcurrentHashMap;", "Lredis/clients/jedis/ShardedJedisPool;", "buildPool", "name", "getConnection", "getPool", "jkmvc-common"})
public final class ShardedJedisFactory
implements IJedisFactory {
    private static final ConcurrentHashMap<String, ShardedJedisPool> pools;
    private static final AllRequestScopedTransferableThreadLocal<HashMap<String, ShardedJedis>> jedises;
    public static final ShardedJedisFactory INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ShardedJedisPool getPool(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ConcurrentMap $receiver$iv = pools;
        boolean $i$f$getOrPutOnce = false;
        Object v = $receiver$iv.get(name);
        if (v == null) {
            synchronized ($receiver$iv) {
                Object object;
                boolean bl = false;
                Object v2 = $receiver$iv.get(name);
                if (v2 == null) {
                    boolean bl2 = false;
                    Object default$iv = object = INSTANCE.buildPool(name);
                    boolean bl3 = false;
                    v2 = $receiver$iv.putIfAbsent(name, default$iv);
                    if (v2 == null) {
                        v2 = default$iv;
                    }
                }
                object = v2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl20 : MonitorExitStatement: MONITOREXIT : $receiver$iv
                v = object;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(v, (String)"pools.getOrPutOnce(name)\u2026buildPool(name)\n        }");
        return (ShardedJedisPool)v;
    }

    /*
     * WARNING - void declaration
     */
    private final ShardedJedisPool buildPool(String name) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Config config = Config.Companion.instance("redis." + name, "yaml");
        String string = IConfig.getString$default(config, "address", null, 2, null);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        List<Pair<String, Integer>> addresses = AddressesParser.INSTANCE.parse(string);
        String pass = IConfig.getString$default(config, "password", null, 2, null);
        JedisPoolConfig poolConfig = this.buildJedisPoolConfig(config);
        Iterable iterable = $receiver$iv = (Iterable)addresses;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void host;
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_13 = it;
            String string2 = (String)var14_13.component1();
            int port = ((Number)var14_13.component2()).intValue();
            JedisShardInfo jedisShardInfo = new JedisShardInfo((String)host, port, 10000);
            collection.add(jedisShardInfo);
        }
        List shards = (List)destination$iv$iv;
        return new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards);
    }

    @NotNull
    public final ShardedJedis getConnection(@NotNull String name) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Map $receiver$iv = (Map)ScopedTransferableThreadLocal.get$default(jedises, false, 1, null);
        Object value$iv = $receiver$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            ShardedJedis shardedJedis = INSTANCE.getPool(name).getResource();
            Intrinsics.checkExpressionValueIsNotNull((Object)shardedJedis, (String)"getPool(name).resource");
            ShardedJedis answer$iv = shardedJedis;
            $receiver$iv.put(name, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ShardedJedis jedis = (ShardedJedis)object;
        return jedis;
    }

    @NotNull
    public static /* synthetic */ ShardedJedis getConnection$default(ShardedJedisFactory shardedJedisFactory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        return shardedJedisFactory.getConnection(string);
    }

    private ShardedJedisFactory() {
    }

    static {
        ShardedJedisFactory shardedJedisFactory;
        INSTANCE = shardedJedisFactory = new ShardedJedisFactory();
        pools = new ConcurrentHashMap();
        jedises = new AllRequestScopedTransferableThreadLocal<HashMap<String, ShardedJedis>>((Function0)jedises.2.INSTANCE){

            public void doEndScope() {
                HashMap jedises2 = (HashMap)ScopedTransferableThreadLocal.get$default(this, false, 1, null);
                Map map2 = jedises2;
                Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    String name = (String)entry2.getKey();
                    entry2 = entry;
                    ShardedJedis jedis = (ShardedJedis)entry2.getValue();
                    jedis.close();
                }
                jedises2.clear();
                super.doEndScope();
            }
        };
    }

    @Override
    @NotNull
    public JedisPoolConfig buildJedisPoolConfig(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        return IJedisFactory.DefaultImpls.buildJedisPoolConfig(this, config);
    }
}

