/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.common.Config;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.JedisPoolConfig;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lnet/jkcode/jkmvc/redis/IJedisFactory;", "", "buildJedisPoolConfig", "Lredis/clients/jedis/JedisPoolConfig;", "config", "Lnet/jkcode/jkmvc/common/Config;", "jkmvc-common"})
public interface IJedisFactory {
    @NotNull
    public JedisPoolConfig buildJedisPoolConfig(@NotNull Config var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static JedisPoolConfig buildJedisPoolConfig(IJedisFactory $this, @NotNull Config config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            Integer n = config.getInt("maxTotal", 100);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setMaxTotal(n.intValue());
            Integer n2 = config.getInt("maxIdle", 10);
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setMaxIdle(n2.intValue());
            Integer n3 = config.getInt("minIdle", 5);
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setMinIdle(n3.intValue());
            Long l = config.getLong("maxWaitMillis", 10000L);
            if (l == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setMaxWaitMillis(l.longValue());
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTestWhileIdle(true);
            Long l2 = config.getLong("timeBetweenEvictionRunsMillis", 30000L);
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setTimeBetweenEvictionRunsMillis(l2.longValue());
            Integer n4 = config.getInt("numTestsPerEvictionRun", 10);
            if (n4 == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setNumTestsPerEvictionRun(n4.intValue());
            Long l3 = config.getLong("minEvictableIdleTimeMillis", 60000L);
            if (l3 == null) {
                Intrinsics.throwNpe();
            }
            poolConfig.setMinEvictableIdleTimeMillis(l3.longValue());
            return poolConfig;
        }
    }
}

