/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.lock;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.common.Application;
import net.jkcode.jkmvc.lock.IDistributedKeyLock;
import net.jkcode.jkmvc.redis.ShardedJedisFactory;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.ShardedJedis;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lnet/jkcode/jkmvc/lock/JedisKeyLock;", "Lnet/jkcode/jkmvc/lock/IDistributedKeyLock;", "()V", "doQuickLock", "", "key", "", "expireSeconds", "", "doUnlock", "", "Companion", "jkmvc-common"})
public final class JedisKeyLock
extends IDistributedKeyLock {
    @NotNull
    private static final String KeyPrefix = "lock/";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean doQuickLock(@NotNull Object key, int expireSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String path = KeyPrefix + key;
        if (this.isNotExpired(key)) {
            Companion.getJedis().expire(path, expireSeconds);
            return true;
        }
        if (Companion.getJedis().setnx(path, Application.INSTANCE.getFullWorkerId()) == Long.valueOf(0L)) {
            if (Companion.getJedis().ttl(path) == Long.valueOf(-1L)) {
                Companion.getJedis().del(path);
            }
            return false;
        }
        Companion.getJedis().expire(path, expireSeconds);
        return true;
    }

    @Override
    public void doUnlock(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (this.isNotExpired(key)) {
            String path = KeyPrefix + key;
            Companion.getJedis().del(path);
        }
    }

    static {
        KeyPrefix = KeyPrefix;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/jkcode/jkmvc/lock/JedisKeyLock$Companion;", "", "()V", "KeyPrefix", "", "getKeyPrefix", "()Ljava/lang/String;", "jedis", "Lredis/clients/jedis/ShardedJedis;", "getJedis", "()Lredis/clients/jedis/ShardedJedis;", "jkmvc-common"})
    public static final class Companion {
        @NotNull
        public final String getKeyPrefix() {
            return KeyPrefix;
        }

        @NotNull
        protected final ShardedJedis getJedis() {
            return ShardedJedisFactory.getConnection$default(ShardedJedisFactory.INSTANCE, null, 1, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

