/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.lock;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.common._DateKt;
import net.jkcode.jkmvc.lock.IDistributedKeyLock;
import net.jkcode.jkmvc.lock.IKeyLock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H&J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0016R\"\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/jkcode/jkmvc/lock/IDistributedKeyLock;", "Lnet/jkcode/jkmvc/lock/IKeyLock;", "()V", "key2ExpireTimes", "Ljava/lang/ThreadLocal;", "", "", "", "doQuickLock", "", "key", "expireSeconds", "", "doUnlock", "", "isNotExpired", "quickLock", "unlock", "jkmvc-common"})
public abstract class IDistributedKeyLock
implements IKeyLock {
    private final ThreadLocal<Map<Object, Long>> key2ExpireTimes;

    public final boolean isNotExpired(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Long expireTime = this.key2ExpireTimes.get().get(key);
        return expireTime != null && expireTime < _DateKt.currMillis();
    }

    @Override
    public boolean quickLock(@NotNull Object key, int expireSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        boolean result = this.doQuickLock(key, expireSeconds);
        if (result) {
            Map<Object, Long> map2 = this.key2ExpireTimes.get();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"key2ExpireTimes.get()");
            Map<Object, Long> map3 = map2;
            Long l = _DateKt.currMillis() + (long)(expireSeconds * 1000);
            map3.put(key, l);
        }
        return result;
    }

    public abstract boolean doQuickLock(@NotNull Object var1, int var2);

    @Override
    public void unlock(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.doUnlock(key);
        this.key2ExpireTimes.get().remove(key);
    }

    public abstract void doUnlock(@NotNull Object var1);

    public IDistributedKeyLock() {
        ThreadLocal threadLocal = ThreadLocal.withInitial(key2ExpireTimes.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"ThreadLocal.withInitial \u2026shMap<Any, Long?>()\n    }");
        this.key2ExpireTimes = threadLocal;
    }

    @Override
    public boolean quickLockCleanly(@NotNull Object key, int expireSeconds, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return IKeyLock.DefaultImpls.quickLockCleanly(this, key, expireSeconds, block);
    }
}

