/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.flusher;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.flusher.RequestQueueFlusher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lnet/jkcode/jkmvc/flusher/UnitRequestQueueFlusher;", "RequestType", "Lnet/jkcode/jkmvc/flusher/RequestQueueFlusher;", "", "flushQuota", "", "flushTimeoutMillis", "", "(IJ)V", "noResponse", "", "getNoResponse", "()Z", "addAll", "Ljava/util/concurrent/CompletableFuture;", "reqs", "", "jkmvc-common"})
public abstract class UnitRequestQueueFlusher<RequestType>
extends RequestQueueFlusher<RequestType, Unit> {
    private final boolean noResponse = true;

    @Override
    protected boolean getNoResponse() {
        return this.noResponse;
    }

    @NotNull
    public final CompletableFuture<Unit> addAll(@NotNull List<? extends RequestType> reqs) {
        Intrinsics.checkParameterIsNotNull(reqs, (String)"reqs");
        int index = this.currIndex();
        ConcurrentLinkedQueue queue = this.getQueues()[index];
        CompletableFuture<Unit> resFuture = new CompletableFuture<Unit>();
        for (RequestType arg : reqs) {
            queue.offer(TuplesKt.to(arg, resFuture));
        }
        this.tryFlushWhenAdd(queue.size());
        return resFuture;
    }

    public UnitRequestQueueFlusher(int flushQuota, long flushTimeoutMillis) {
        super(flushQuota, flushTimeoutMillis);
    }
}

