/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.common;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.jkcode.jkmvc.common.Application;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a7\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00100\u0015\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0013H\u0002\u001a\n\u0010\u001b\u001a\u00020\u0013*\u00020\u0013\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u001d\u001a\n\u0010 \u001a\u00020\u001a*\u00020\u0001\u001a\n\u0010!\u001a\u00020\u001a*\u00020\u001f\u001a\n\u0010\"\u001a\u00020\u0010*\u00020\u0001\u001a-\u0010#\u001a\u00020\u0010*\u00020\u00132!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00010\u0015\u001a-\u0010&\u001a\u00020\u0010*\u00020\u00132!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00100\u0015\u001aB\u0010&\u001a\u00020\u0010*\u00020\u001f26\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00100'\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"fileSizeUnits", "", "jarUrlProtocol", "Lkotlin/text/Regex;", "bytes2FileSize", "size", "", "fileSize2Bytes", "sizeStr", "fileSizeUnit2Bytes", "unit", "", "getResourceRelativePath", "absolutePath", "rootPath", "travelFiles", "", "files", "Ljava/util/Stack;", "Ljava/io/File;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "createNewFileSafely", "", "createOrRename", "getRootPath", "Ljava/lang/ClassLoader;", "getRootResource", "Ljava/net/URL;", "isAbsolutePath", "isJar", "prepareDirectory", "replaceText", "transform", "txt", "travel", "Lkotlin/Function2;", "relativePath", "isDir", "jkmvc-common"})
public final class _FileKt {
    private static final String fileSizeUnits = "BKMGT";
    private static final Regex jarUrlProtocol;

    public static final long fileSizeUnit2Bytes(char unit) {
        int i2 = StringsKt.indexOf$default((CharSequence)fileSizeUnits, (char)unit, (int)0, (boolean)false, (int)6, null);
        if (i2 == -1) {
            throw (Throwable)new IllegalArgumentException("\u65e0\u6548\u6587\u4ef6\u5927\u5c0f\u5355\u4f4d: " + unit);
        }
        return (long)Math.pow(1024.0, i2);
    }

    public static final long fileSize2Bytes(@NotNull String sizeStr) {
        Intrinsics.checkParameterIsNotNull((Object)sizeStr, (String)"sizeStr");
        String string = sizeStr;
        int n = 0;
        int n2 = sizeStr.length() - 1;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string2;
        int size = Integer.parseInt(string);
        char unit = sizeStr.charAt(sizeStr.length() - 1);
        return (long)size * _FileKt.fileSizeUnit2Bytes(unit);
    }

    @NotNull
    public static final String bytes2FileSize(long size) {
        if (size <= 0L) {
            return "0B";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + fileSizeUnits.charAt(digitGroups);
    }

    public static final boolean isAbsolutePath(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.startsWith$default((String)$receiver, (String)"/", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)$receiver, (String)":", (int)0, (boolean)false, (int)6, null) > 0;
    }

    public static final void prepareDirectory(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File dir = new File($receiver);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @NotNull
    public static final File createOrRename(@NotNull File $receiver) {
        String newName;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (_FileKt.createNewFileSafely($receiver)) {
            return $receiver;
        }
        String name = $receiver.getName();
        String body = null;
        String ext = null;
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        int dot = StringsKt.lastIndexOf$default((CharSequence)string, (String)".", (int)0, (boolean)false, (int)6, null);
        if (dot != -1) {
            String string2 = name;
            int n = 0;
            String string3 = string2.substring(n, dot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            body = string3;
            string2 = name;
            String string4 = string2.substring(dot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            ext = string4;
        } else {
            body = name;
            ext = "";
        }
        int count = 0;
        File newfile = null;
        do {
            newName = body + ++count + ext;
        } while (!_FileKt.createNewFileSafely(newfile = new File($receiver.getParent(), newName)) && count < 9999);
        return newfile;
    }

    private static final boolean createNewFileSafely(@NotNull File $receiver) {
        try {
            return $receiver.createNewFile();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static final void replaceText(@NotNull File $receiver, @NotNull Function1<? super String, String> transform) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        String txt = FilesKt.readText$default((File)$receiver, null, (int)1, null);
        String newTxt = (String)transform.invoke((Object)txt);
        FilesKt.writeText$default((File)$receiver, (String)newTxt, null, (int)2, null);
    }

    public static final void travel(@NotNull File $receiver, @NotNull Function1<? super File, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Stack<File> files = new Stack<File>();
        files.push($receiver);
        _FileKt.travelFiles(files, action);
    }

    public static final void travelFiles(@NotNull Stack<File> files, @NotNull Function1<? super File, Unit> action) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        while (!files.isEmpty()) {
            File file;
            File file2 = file = files.pop();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (file2.isDirectory()) {
                Collection collection = files;
                Object[] objectArray = file.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"file.listFiles()");
                CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                continue;
            }
            action.invoke((Object)file);
        }
    }

    public static final boolean isJar(@NotNull URL $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"protocol");
        return jarUrlProtocol.matches((CharSequence)string);
    }

    @NotNull
    public static final URL getRootResource(@NotNull ClassLoader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        URL res = $receiver.getResource("/");
        if (res != null) {
            return res;
        }
        URL uRL = $receiver.getResource(".");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"getResource(\".\")");
        return uRL;
    }

    @NotNull
    public static final String getRootPath(@NotNull ClassLoader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String root = _FileKt.getRootResource($receiver).getPath();
        if (Application.INSTANCE.isWin()) {
            String string = root;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null)) {
                String string2 = root;
                int n = 1;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                root = string3;
                root = StringsKt.replace$default((String)root, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
            }
        }
        String string = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root");
        return string;
    }

    public static final void travel(@NotNull URL $receiver, @NotNull Function2<? super String, ? super Boolean, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if (_FileKt.isJar($receiver)) {
            URLConnection uRLConnection = $receiver.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.JarURLConnection");
            }
            JarURLConnection conn = (JarURLConnection)uRLConnection;
            JarFile jarFile = conn.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"jarFile.entries()");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                JarEntry entry;
                JarEntry jarEntry = entry = (JarEntry)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"entry");
                String string = jarEntry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                boolean isDir = StringsKt.endsWith$default((CharSequence)string, (char)File.separatorChar, (boolean)false, (int)2, null);
                String string2 = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                action.invoke((Object)string2, (Object)isDir);
            }
        } else {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            ClassLoader classLoader = thread.getContextClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"Thread.currentThread().contextClassLoader");
            String rootPath = _FileKt.getRootPath(classLoader);
            _FileKt.travel(new File($receiver.getPath()), (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(rootPath, action){
                final /* synthetic */ String $rootPath;
                final /* synthetic */ Function2 $action;

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.path");
                    String relativePath = _FileKt.access$getResourceRelativePath(string, this.$rootPath);
                    this.$action.invoke((Object)relativePath, (Object)it.isDirectory());
                }
                {
                    this.$rootPath = string;
                    this.$action = function2;
                    super(1);
                }
            }));
        }
    }

    private static final String getResourceRelativePath(String absolutePath, String rootPath) {
        if (StringsKt.startsWith$default((String)absolutePath, (String)rootPath, (boolean)false, (int)2, null)) {
            String string = absolutePath;
            int n = rootPath.length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return (String)StringsKt.split$default((CharSequence)absolutePath, (String[])new String[]{"classes" + File.separatorChar}, (boolean)false, (int)0, (int)6, null).get(1);
    }

    static {
        fileSizeUnits = fileSizeUnits;
        String string = "jar|zip|wsjar|code-source";
        jarUrlProtocol = new Regex(string);
    }

    public static final /* synthetic */ String access$getResourceRelativePath(String absolutePath, String rootPath) {
        return _FileKt.getResourceRelativePath(absolutePath, rootPath);
    }
}

