/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.common.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lnet/jkcode/jkmvc/common/ModuleLogSwitcher;", "", "module", "", "(Ljava/lang/String;)V", "disableMethods", "", "getDisableMethods", "()[Ljava/lang/String;", "[Ljava/lang/String;", "disabled", "", "getDisabled", "()Z", "enabled", "getEnabled", "getModule", "()Ljava/lang/String;", "getLogger", "Lorg/slf4j/Logger;", "name", "Companion", "ModuleLoggerHandler", "jkmvc-common"})
public final class ModuleLogSwitcher {
    private final boolean enabled;
    private final boolean disabled;
    @NotNull
    private final String[] disableMethods;
    @NotNull
    private final String module;
    @NotNull
    private static final Config config;
    public static final Companion Companion;

    protected final boolean getEnabled() {
        return this.enabled;
    }

    protected final boolean getDisabled() {
        return this.disabled;
    }

    @NotNull
    protected final String[] getDisableMethods() {
        return this.disableMethods;
    }

    @NotNull
    public final Logger getLogger(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Logger logger = LoggerFactory.getLogger((String)name);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class[] classArray = new Class[]{Logger.class};
        Logger logger2 = logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new ModuleLoggerHandler(logger2));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.slf4j.Logger");
        }
        return (Logger)object;
    }

    @NotNull
    protected final String getModule() {
        return this.module;
    }

    public ModuleLogSwitcher(@NotNull String module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.module = module;
        Boolean bl = config.getBoolean(this.module, true);
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        this.enabled = bl;
        this.disabled = !this.enabled;
        this.disableMethods = new String[]{"debug", "info", "warn"};
    }

    static {
        Companion = new Companion(null);
        config = Config.Companion.instance("module-log-switcher", "yaml");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/jkcode/jkmvc/common/ModuleLogSwitcher$ModuleLoggerHandler;", "Ljava/lang/reflect/InvocationHandler;", "delegate", "Lorg/slf4j/Logger;", "(Lnet/jkcode/jkmvc/common/ModuleLogSwitcher;Lorg/slf4j/Logger;)V", "getDelegate", "()Lorg/slf4j/Logger;", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "jkmvc-common"})
    public final class ModuleLoggerHandler
    implements InvocationHandler {
        @NotNull
        private final Logger delegate;

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            if (!ModuleLogSwitcher.this.getEnabled() && ArraysKt.contains((Object[])ModuleLogSwitcher.this.getDisableMethods(), (Object)method.getName())) {
                return null;
            }
            return method.invoke((Object)this.delegate, Arrays.copyOf(args, args.length));
        }

        @NotNull
        protected final Logger getDelegate() {
            return this.delegate;
        }

        public ModuleLoggerHandler(Logger delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/jkcode/jkmvc/common/ModuleLogSwitcher$Companion;", "", "()V", "config", "Lnet/jkcode/jkmvc/common/Config;", "getConfig", "()Lnet/jkcode/jkmvc/common/Config;", "jkmvc-common"})
    public static final class Companion {
        @NotNull
        public final Config getConfig() {
            return config;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

