/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.common;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jkcode.jkmvc.bit.IBitSet;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;

public class FixedKeyMapFactory {
    protected final String[] _keys;
    protected final int[] _keyHashs;

    public FixedKeyMapFactory(String ... keys) {
        this._keys = keys;
        List<String> allKeys = Arrays.asList(keys);
        HashSet<String> uniqueKeys = new HashSet<String>(allKeys);
        if (uniqueKeys.size() != keys.length) {
            allKeys.removeAll(uniqueKeys);
            throw new IllegalArgumentException("The supplied keys must be unique, but the following keys are duplicated: " + allKeys);
        }
        this._keyHashs = new int[keys.length];
        for (int i2 = 0; i2 < keys.length; ++i2) {
            this._keyHashs[i2] = keys[i2].hashCode();
        }
    }

    public Map<String, Object> createMap(Object ... values) {
        if (values.length == 0) {
            values = new Object[this._keys.length];
        }
        if (values.length != this._keys.length) {
            throw new IllegalArgumentException("There are " + this._keys.length + " keys, so that many values must be supplied");
        }
        return new FixedKeyMap(values);
    }

    public int indexOf(Object key) {
        int keyHashCode = key.hashCode();
        for (int i2 = 0; i2 < this._keys.length; ++i2) {
            if (this._keyHashs[i2] != keyHashCode || !this._keys[i2].equals(key)) continue;
            return i2;
        }
        return -1;
    }

    protected final class FixedKeyMap
    extends AbstractMap<String, Object> {
        protected final Object[] _values;
        protected final BitSet _dirtyBits;
        protected transient Set<Map.Entry<String, Object>> _entrySet;

        protected FixedKeyMap(Object[] values) {
            this._dirtyBits = new BitSet(FixedKeyMapFactory.this._keys.length);
            this._values = values;
        }

        @Override
        public Object get(Object key) {
            int i2 = FixedKeyMapFactory.this.indexOf(key);
            if (i2 == -1) {
                return null;
            }
            return this._values[i2];
        }

        @Override
        public boolean isEmpty() {
            return this._dirtyBits.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            int i2 = FixedKeyMapFactory.this.indexOf(key);
            return i2 > -1 && this._dirtyBits.get(i2);
        }

        @Override
        public boolean containsValue(Object value) {
            int i2 = this._dirtyBits.nextSetBit(0);
            while (i2 >= 0) {
                Object o = this._values[i2];
                if (value == null ? o == null : value.equals(o)) {
                    return true;
                }
                i2 = this._dirtyBits.nextSetBit(i2 + 1);
            }
            return false;
        }

        @Override
        public Object put(String key, Object value) {
            int i2 = FixedKeyMapFactory.this.indexOf(key);
            if (i2 == -1) {
                throw new IllegalArgumentException("Unkown key: " + key);
            }
            Object oldValue = this._values[i2];
            this._values[i2] = value;
            this._dirtyBits.set(i2);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            int i2 = FixedKeyMapFactory.this.indexOf(key);
            return this.remove(i2);
        }

        public Object remove(int i2) {
            Object oldValue = this._values[i2];
            this._values[i2] = null;
            this._dirtyBits.clear(i2);
            return oldValue;
        }

        @Override
        public void clear() {
            for (int i2 = 0; i2 < this._values.length; ++i2) {
                this._values[i2] = null;
            }
            this._dirtyBits.clear();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this._entrySet == null) {
                this._entrySet = new EntrySet();
            }
            return this._entrySet;
        }

        protected class EntrySet
        extends IBitSet<Map.Entry<String, Object>> {
            public EntrySet() {
                super(FixedKeyMap.this._dirtyBits);
            }

            @Override
            public Map.Entry<String, Object> getElement(int index) {
                try {
                    return new DefaultMapEntry((Object)FixedKeyMapFactory.this._keys[index], FixedKeyMap.this._values[index]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public boolean removeElement(int index) {
                return FixedKeyMap.this.remove(index) != null;
            }

            @Override
            public int size() {
                return FixedKeyMapFactory.this._keys.length;
            }
        }
    }
}

