/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jkcode.jkmvc.cache.BaseCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/jkcode/jkmvc/cache/LRUCache;", "Lnet/jkcode/jkmvc/cache/BaseCache;", "maxSize", "", "(I)V", "getMaxSize", "()I", "storage", "Ljava/util/LinkedHashMap;", "", "getStorage", "()Ljava/util/LinkedHashMap;", "clear", "", "doGet", "key", "doPut", "value", "expireSencond", "", "remove", "jkmvc-common"})
public final class LRUCache
extends BaseCache {
    @NotNull
    private final LinkedHashMap<Object, Object> storage;
    private final int maxSize;

    @NotNull
    protected final LinkedHashMap<Object, Object> getStorage() {
        return this.storage;
    }

    @Override
    @Nullable
    public synchronized Object doGet(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.storage.get(key);
    }

    @Override
    public synchronized void doPut(@NotNull Object key, @NotNull Object value, long expireSencond) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.storage.put(key, value);
    }

    @Override
    public synchronized void remove(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.storage.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.storage.clear();
    }

    protected final int getMaxSize() {
        return this.maxSize;
    }

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.storage = new LinkedHashMap<Object, Object>(this, this.maxSize + 1, 0.75f, true){
            final /* synthetic */ LRUCache this$0;

            protected boolean removeEldestEntry(@Nullable Map.Entry<Object, Object> eldest) {
                return this.size() > this.this$0.getMaxSize();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
    }

    public /* synthetic */ LRUCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10000;
        }
        this(n);
    }

    public LRUCache() {
        this(0, 1, null);
    }
}

