/*
 * Decompiled with CFR 0.152.
 */
package net.jkcode.jkmvc.cache;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import net.jkcode.jkmvc.cache.BaseCache;
import net.jkcode.jkmvc.common.Config;
import net.jkcode.jkmvc.common._StringKt;
import net.jkcode.jkmvc.redis.ShardedJedisFactory;
import net.jkcode.jkmvc.serialize.ISerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.ShardedJedis;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lnet/jkcode/jkmvc/cache/JedisCache;", "Lnet/jkcode/jkmvc/cache/BaseCache;", "configName", "", "(Ljava/lang/String;)V", "config", "Lnet/jkcode/jkmvc/common/Config;", "getConfig", "()Lnet/jkcode/jkmvc/common/Config;", "getConfigName", "()Ljava/lang/String;", "jedis", "Lredis/clients/jedis/ShardedJedis;", "getJedis", "()Lredis/clients/jedis/ShardedJedis;", "serializer", "Lnet/jkcode/jkmvc/serialize/ISerializer;", "getSerializer", "()Lnet/jkcode/jkmvc/serialize/ISerializer;", "clear", "", "doGet", "", "key", "doPut", "value", "expireSencond", "", "remove", "jkmvc-common"})
public final class JedisCache
extends BaseCache {
    @NotNull
    private final Config config;
    @NotNull
    private final ISerializer serializer;
    @NotNull
    private final String configName;

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final ISerializer getSerializer() {
        return this.serializer;
    }

    @NotNull
    protected final ShardedJedis getJedis() {
        return ShardedJedisFactory.INSTANCE.getConnection(this.configName);
    }

    @Override
    @Nullable
    public Object doGet(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] value = this.getJedis().get(this.serializer.serialize(key));
        if (value == null) {
            return null;
        }
        return this.serializer.unserialize(value);
    }

    @Override
    public void doPut(@NotNull Object key, @NotNull Object value, long expireSencond) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = "NX";
        byte[] byArray = this.serializer.serialize(value);
        byte[] byArray2 = this.serializer.serialize(key);
        ShardedJedis shardedJedis = this.getJedis();
        Charset charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        string = "EX";
        charset = Charsets.UTF_8;
        byte[] byArray5 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray6 = byArray5;
        shardedJedis.set(byArray2, byArray, byArray4, byArray6, expireSencond);
    }

    @Override
    public void remove(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.getJedis().del(this.serializer.serialize(key));
    }

    @Override
    public void clear() {
        throw (Throwable)new UnsupportedOperationException("not implemented");
    }

    @NotNull
    protected final String getConfigName() {
        return this.configName;
    }

    /*
     * WARNING - void declaration
     */
    public JedisCache(@NotNull String configName) {
        Object object;
        Object object2;
        void key$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)configName, (String)"configName");
        this.configName = configName;
        Config config = this.config = Config.Companion.instance("redis." + this.configName, "yaml");
        String string = "serializer";
        ISerializer.Companion companion = ISerializer.Companion;
        JedisCache jedisCache = this;
        Object defaultValue$iv = null;
        boolean $i$f$get = false;
        Map<String, ?> $receiver$iv$iv = this_$iv.getProps();
        boolean $i$f$getAndConvert = false;
        Object object3 = $receiver$iv$iv;
        Object value$iv$iv = object3.get(key$iv);
        if (value$iv$iv == null) {
            object2 = defaultValue$iv;
        } else if (value$iv$iv instanceof String) {
            object2 = value$iv$iv;
        } else if (value$iv$iv instanceof String) {
            void $receiver$iv$iv$iv;
            object3 = (String)value$iv$iv;
            KClass clazz$iv$iv$iv = Reflection.getOrCreateKotlinClass(String.class);
            boolean $i$f$to = false;
            if (JvmClassMappingKt.getJavaClass((KClass)clazz$iv$iv$iv).isAssignableFrom(String.class)) {
                object2 = $receiver$iv$iv$iv;
            } else {
                Comparable<Integer> comparable;
                KClass kClass = clazz$iv$iv$iv;
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    void var13_15 = $receiver$iv$iv$iv;
                    comparable = Integer.parseInt((String)var13_15);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    void var13_16 = $receiver$iv$iv$iv;
                    comparable = Long.parseLong((String)var13_16);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    void var13_17 = $receiver$iv$iv$iv;
                    comparable = Float.valueOf(Float.parseFloat((String)var13_17));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    void var13_18 = $receiver$iv$iv$iv;
                    comparable = Double.parseDouble((String)var13_18);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    void var13_19 = $receiver$iv$iv$iv;
                    comparable = Boolean.parseBoolean((String)var13_19);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    void var13_20 = $receiver$iv$iv$iv;
                    comparable = Short.parseShort((String)var13_20);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                    void var13_21 = $receiver$iv$iv$iv;
                    comparable = Byte.parseByte((String)var13_21);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Date.class))) {
                    comparable = _StringKt.toDate((String)$receiver$iv$iv$iv);
                } else {
                    throw (Throwable)new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u81ea\u52a8\u8f6c\u6362\u4e3a\u672a\u8bc6\u522b\u7684\u7c7b\u578b: " + clazz$iv$iv$iv);
                }
                object2 = comparable;
                if (comparable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
            }
        } else {
            throw (Throwable)new ClassCastException("Fail to convert [" + value$iv$iv + "] to type [" + Reflection.getOrCreateKotlinClass(String.class) + ']');
        }
        Object object4 = object = object2;
        if (object4 == null) {
            Intrinsics.throwNpe();
        }
        jedisCache.serializer = (ISerializer)companion.instance((String)object4);
    }

    public /* synthetic */ JedisCache(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "default";
        }
        this(string);
    }

    public JedisCache() {
        this(null, 1, null);
    }
}

