/*
 * Decompiled with CFR 0.152.
 */
package net.jini.id;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Uuid
implements Serializable {
    private static final long serialVersionUID = -106268922535833151L;
    private final long bits0;
    private final long bits1;

    protected Uuid(long bits0, long bits1) {
        if (!this.isValid()) {
            throw new SecurityException("invalid class: " + this.getClass().getName());
        }
        this.bits0 = bits0;
        this.bits1 = bits1;
    }

    public final long getMostSignificantBits() {
        return this.bits0;
    }

    public final long getLeastSignificantBits() {
        return this.bits1;
    }

    public final int hashCode() {
        return (int)(this.bits0 >>> 32 ^ this.bits0 ^ this.bits1 >>> 32 ^ this.bits1);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Uuid) {
            Uuid other = (Uuid)obj;
            return this.bits0 == other.bits0 && this.bits1 == other.bits1;
        }
        return false;
    }

    public final String toString() {
        return this.toHexString(this.bits0 >>> 32, 8) + "-" + this.toHexString(this.bits0 >>> 16, 4) + "-" + this.toHexString(this.bits0 >>> 0, 4) + "-" + this.toHexString(this.bits1 >>> 48, 4) + "-" + this.toHexString(this.bits1 >>> 0, 12);
    }

    private String toHexString(long value, int digits) {
        long cutoff = 1L << digits * 4;
        return Long.toHexString(cutoff | value & cutoff - 1L).substring(1);
    }

    public final void write(OutputStream out) throws IOException {
        Uuid.writeLong(this.bits0, out);
        Uuid.writeLong(this.bits1, out);
    }

    private static void writeLong(long value, OutputStream out) throws IOException {
        out.write((int)(value >>> 56) & 0xFF);
        out.write((int)(value >>> 48) & 0xFF);
        out.write((int)(value >>> 40) & 0xFF);
        out.write((int)(value >>> 32) & 0xFF);
        out.write((int)(value >>> 24) & 0xFF);
        out.write((int)(value >>> 16) & 0xFF);
        out.write((int)(value >>> 8) & 0xFF);
        out.write((int)(value >>> 0) & 0xFF);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    protected final Object writeReplace() {
        return this;
    }

    protected final Object readResolve() {
        return this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!this.isValid()) {
            throw new InvalidObjectException("invalid class: " + this.getClass().getName());
        }
        in.defaultReadObject();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private boolean isValid() {
        return !(this instanceof Externalizable);
    }
}

