/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.Security;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class ActivatableInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -428224070630550856L;
    private static final int MAX_RETRIES = 3;
    private static final Logger logger;
    private static final Class[] constructorArgs;
    private static final boolean enableGrant;
    private final ActivationID id;
    private Remote uproxy;
    private final MethodConstraints clientConstraints;
    private static final Method getPtiMethod;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActivatableInvocationHandler(ActivationID id, Remote underlyingProxy) {
        MethodConstraints uproxyConstraints;
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        this.id = id;
        this.uproxy = underlyingProxy;
        this.clientConstraints = null;
        if (this.uproxy instanceof RemoteMethodControl && (uproxyConstraints = ((RemoteMethodControl)this.uproxy).getConstraints()) != null) {
            this.uproxy = (Remote)((RemoteMethodControl)this.uproxy).setConstraints(null);
        }
    }

    private boolean hasConsistentConstraints() {
        if (this.uproxy instanceof RemoteMethodControl) {
            MethodConstraints uproxyConstraints = ((RemoteMethodControl)this.uproxy).getConstraints();
            return this.clientConstraints == null ? uproxyConstraints == null : this.clientConstraints.equals(uproxyConstraints);
        }
        return true;
    }

    private ActivatableInvocationHandler(ActivationID id, Remote underlyingProxy, MethodConstraints clientConstraints) {
        this.id = id;
        this.uproxy = underlyingProxy;
        this.clientConstraints = clientConstraints;
    }

    public ActivationID getActivationID() {
        return this.id;
    }

    public synchronized Object getCurrentProxy() {
        return this.uproxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> decl = method.getDeclaringClass();
        if (proxy instanceof InvocationHandler) {
            throw new IllegalArgumentException("proxy cannot be an invocation handler");
        }
        if (decl == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        if (decl == RemoteMethodControl.class) {
            return this.invokeRemoteMethodControlMethod(proxy, method, args);
        }
        if (decl == TrustEquivalence.class) {
            return this.invokeTrustEquivalenceMethod(proxy, method, args);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethodControlMethod(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("setConstraints")) {
            Remote newProxy;
            if (Proxy.getInvocationHandler(proxy) != this) {
                throw new IllegalArgumentException("not proxy for this");
            }
            ActivatableInvocationHandler activatableInvocationHandler = this;
            synchronized (activatableInvocationHandler) {
                newProxy = this.uproxy;
            }
            MethodConstraints mc = (MethodConstraints)args[0];
            if (newProxy instanceof RemoteMethodControl) {
                newProxy = (Remote)((RemoteMethodControl)newProxy).setConstraints(mc);
            }
            Class<?> proxyClass = proxy.getClass();
            return Proxy.newProxyInstance(ActivatableInvocationHandler.getProxyLoader(proxyClass), proxyClass.getInterfaces(), (InvocationHandler)new ActivatableInvocationHandler(this.id, newProxy, mc));
        }
        if (name.equals("getConstraints")) {
            return this.clientConstraints;
        }
        throw new AssertionError(method);
    }

    private Object invokeTrustEquivalenceMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("checkTrustEquivalence")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.checkTrustEquivalence(Proxy.getInvocationHandler(obj));
            return b;
        }
        throw new AssertionError(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Remote currProxy;
        InvocationConstraints absoluteConstraints;
        InvocationConstraints relativeConstraints;
        Util.checkProxyRemoteMethod(proxy.getClass(), method);
        BasicMethodConstraints convertedConstraints = null;
        if (this.clientConstraints != null && (relativeConstraints = this.clientConstraints.getConstraints(method)) != (absoluteConstraints = relativeConstraints.makeAbsolute())) {
            convertedConstraints = new BasicMethodConstraints(absoluteConstraints);
        }
        boolean force = false;
        Failure failure = null;
        ActivatableInvocationHandler activatableInvocationHandler = this;
        synchronized (activatableInvocationHandler) {
            if (this.uproxy == null) {
                this.activate(force, proxy, method);
                force = true;
            }
            currProxy = this.uproxy;
        }
        int retries = 3;
        while (--retries >= 0) {
            if (logger.isLoggable(Levels.HANDLED) && failure != null) {
                this.logThrow(Levels.HANDLED, "outbound call", "invokeRemoteMethod", method, failure.exception);
            }
            if (this.clientConstraints != null && !(currProxy instanceof RemoteMethodControl)) {
                throw new UnsupportedConstraintException("underlying proxy does not implement RemoteMethodControl");
            }
            Remote targetProxy = convertedConstraints == null ? currProxy : (Remote)((RemoteMethodControl)currProxy).setConstraints((MethodConstraints)convertedConstraints);
            Object result = this.invokeMethod(targetProxy, method, args);
            if (result instanceof Failure) {
                failure = (Failure)result;
                if (!failure.retry || retries <= 0) {
                    break;
                }
            } else {
                return result;
            }
            ActivatableInvocationHandler activatableInvocationHandler2 = this;
            synchronized (activatableInvocationHandler2) {
                if (this.uproxy == null || currProxy.equals(this.uproxy)) {
                    this.activate(force, proxy, method);
                    if (currProxy.equals(this.uproxy) && failure.exception instanceof NoSuchObjectException && !force) {
                        this.activate(true, proxy, method);
                    }
                    force = true;
                } else {
                    force = false;
                }
                currProxy = this.uproxy;
            }
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow(Levels.FAILED, "outbound call", "invokeRemoteMethod", method, failure.exception);
        }
        throw failure.exception;
    }

    private void logThrow(Level level, String logRecordText, String sourceMethodName, Method method, Throwable t) {
        LogRecord lr = new LogRecord(level, logRecordText + " {0}.{1} throws");
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(this.getClass().getName());
        lr.setSourceMethodName(sourceMethodName);
        lr.setParameters(new Object[]{method.getDeclaringClass().getName(), method.getName()});
        lr.setThrown(t);
        logger.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            return ActivatableInvocationHandler.invokeMethod0(proxy, m, args);
        }
        catch (NoSuchObjectException e) {
            return new Failure(e, true);
        }
        catch (ConnectException e) {
            return new Failure(e, true);
        }
        catch (UnknownHostException e) {
            return new Failure(e, true);
        }
        catch (ConnectIOException e) {
            return new Failure(e, true);
        }
        catch (MarshalException e) {
            return new Failure(e, false);
        }
        catch (ServerError e) {
            return new Failure(e, false);
        }
        catch (ServerException e) {
            return new Failure(e, false);
        }
        catch (RemoteException e) {
            ActivatableInvocationHandler activatableInvocationHandler = this;
            synchronized (activatableInvocationHandler) {
                if (proxy.equals(this.uproxy)) {
                    this.uproxy = null;
                }
            }
            return new Failure(e, e instanceof ActivateFailedException);
        }
        catch (Exception e) {
            return new Failure(e, false);
        }
    }

    private static Object invokeMethod0(Object proxy, Method m, Object[] args) throws Throwable {
        Class<?> cl;
        Class<?> mcl = m.getDeclaringClass();
        if (!Modifier.isPublic(mcl.getModifiers()) && mcl.isAssignableFrom(cl = proxy.getClass()) && Modifier.isPublic(cl.getModifiers())) {
            try {
                m = cl.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                throw new ActivateFailedException("bad proxy").initCause((Throwable)nsme);
            }
        }
        try {
            return m.invoke(proxy, args);
        }
        catch (IllegalAccessException e) {
            throw new ActivateFailedException("bad proxy").initCause((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ActivateFailedException("bad proxy").initCause((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected ProxyTrustIterator getProxyTrustIterator() {
        return new ProxyTrustIterator(){
            private int retries = 4;
            private boolean force = false;
            private Remote currProxy = null;
            private Exception fail = null;
            private RemoteException ex = null;
            private boolean advance = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean hasNext() {
                if (this.advance) {
                    this.advance = false;
                    if (--this.retries >= 0) {
                        if (this.retries == 3 || this.ex instanceof NoSuchObjectException || this.ex instanceof ConnectException || this.ex instanceof UnknownHostException || this.ex instanceof ConnectIOException) {
                            try {
                                ActivatableInvocationHandler activatableInvocationHandler = ActivatableInvocationHandler.this;
                                synchronized (activatableInvocationHandler) {
                                    if (ActivatableInvocationHandler.this.uproxy == null || ActivatableInvocationHandler.this.uproxy.equals(this.currProxy)) {
                                        ActivatableInvocationHandler.this.activate(this.force, null, getPtiMethod);
                                        if (ActivatableInvocationHandler.this.uproxy.equals(this.currProxy) && this.ex instanceof NoSuchObjectException && !this.force) {
                                            ActivatableInvocationHandler.this.activate(true, null, getPtiMethod);
                                        }
                                        this.force = true;
                                    } else {
                                        this.force = false;
                                    }
                                    this.currProxy = ActivatableInvocationHandler.this.uproxy;
                                }
                            }
                            catch (Exception e) {
                                this.fail = e;
                                this.retries = 0;
                            }
                        } else {
                            this.retries = -1;
                            if (!(this.ex == null || this.ex instanceof MarshalException || this.ex instanceof ServerException || this.ex instanceof ServerError)) {
                                ActivatableInvocationHandler activatableInvocationHandler = ActivatableInvocationHandler.this;
                                synchronized (activatableInvocationHandler) {
                                    if (this.currProxy.equals(ActivatableInvocationHandler.this.uproxy)) {
                                        ActivatableInvocationHandler.this.uproxy = null;
                                    }
                                }
                            }
                        }
                    }
                }
                return this.retries >= 0;
            }

            public synchronized Object next() throws RemoteException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance = true;
                if (this.fail == null) {
                    return this.currProxy;
                }
                if (this.fail instanceof RemoteException) {
                    throw (RemoteException)this.fail;
                }
                throw (RuntimeException)this.fail;
            }

            public synchronized void setException(RemoteException e) {
                if (e == null) {
                    throw new NullPointerException("exception is null");
                }
                if (this.retries > 3 || !this.advance || this.fail != null) {
                    throw new IllegalStateException();
                }
                this.ex = e;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTrustEquivalence(Object obj) {
        Remote otherProxy;
        Remote currProxy;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActivatableInvocationHandler) || !(this.id instanceof TrustEquivalence)) {
            return false;
        }
        ActivatableInvocationHandler other = (ActivatableInvocationHandler)obj;
        if (!((TrustEquivalence)this.id).checkTrustEquivalence(other.id) || this.clientConstraints != other.clientConstraints && (this.clientConstraints == null || !this.clientConstraints.equals(other.clientConstraints))) {
            return false;
        }
        ActivatableInvocationHandler activatableInvocationHandler = this;
        synchronized (activatableInvocationHandler) {
            currProxy = this.uproxy;
        }
        ActivatableInvocationHandler activatableInvocationHandler2 = other;
        synchronized (activatableInvocationHandler2) {
            otherProxy = other.uproxy;
        }
        if (currProxy == null || !(currProxy instanceof TrustEquivalence) || !((TrustEquivalence)((Object)currProxy)).checkTrustEquivalence(otherProxy)) {
            activatableInvocationHandler2 = other;
            synchronized (activatableInvocationHandler2) {
                other.uproxy = null;
            }
        }
        return true;
    }

    private void activate(boolean force, Object proxy, Method method) throws Exception {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            this.activate0(force, proxy);
        }
        catch (Exception e) {
            if (logger.isLoggable(Levels.FAILED)) {
                this.logThrow(Levels.FAILED, "activating object for call", "activate", method, e);
            }
            throw e;
        }
    }

    private void activate0(boolean force, Object proxy) throws RemoteException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.uproxy = null;
        try {
            Remote newProxy;
            if (proxy != null && enableGrant) {
                try {
                    Security.grant(proxy.getClass(), this.id.getClass());
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
            }
            if (!Proxy.isProxyClass((newProxy = this.id.activate(force)).getClass())) {
                throw new ActivateFailedException("invalid proxy");
            }
            InvocationHandler obj = Proxy.getInvocationHandler(newProxy);
            if (!(obj instanceof ActivatableInvocationHandler)) {
                throw new ActivateFailedException("invalid proxy handler");
            }
            ActivatableInvocationHandler handler = (ActivatableInvocationHandler)obj;
            if (!this.id.equals((Object)handler.id)) {
                throw new ActivateFailedException("unexpected activation id");
            }
            Remote newUproxy = handler.uproxy;
            if (newUproxy == null) {
                throw new ActivateFailedException("null underlying proxy");
            }
            if (newUproxy instanceof RemoteMethodControl) {
                newUproxy = (Remote)((RemoteMethodControl)newUproxy).setConstraints(this.clientConstraints);
            }
            this.uproxy = newUproxy;
        }
        catch (ConnectException e) {
            throw new ConnectException("activation failed", e);
        }
        catch (RemoteException e) {
            throw new ConnectIOException("activation failed", e);
        }
        catch (UnknownObjectException e) {
            throw new NoSuchObjectException("object not registered");
        }
        catch (ActivationException e) {
            throw new ActivateFailedException("activation failed", (Exception)((Object)e));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActivatableInvocationHandler)) {
            return false;
        }
        ActivatableInvocationHandler other = (ActivatableInvocationHandler)obj;
        return this.id.equals((Object)other.id) && (this.clientConstraints == other.clientConstraints || this.clientConstraints != null && this.clientConstraints.equals(other.clientConstraints));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "ActivatableInvocationHandler[" + this.id + ", " + this.uproxy + "]";
    }

    private String proxyToString(Object proxy) {
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        Class<?> iface = null;
        int i = interfaces.length;
        while (--i >= 0 && interfaces[i] != (class$net$jini$core$constraint$RemoteMethodControl == null ? ActivatableInvocationHandler.class$("net.jini.core.constraint.RemoteMethodControl") : class$net$jini$core$constraint$RemoteMethodControl)) {
            iface = interfaces[i];
        }
        if (iface == null) {
            return "Proxy[" + this + "]";
        }
        String n = iface.getName();
        int dot = n.lastIndexOf(46);
        if (dot >= 0) {
            n = n.substring(dot + 1);
        }
        return "Proxy[" + n + "," + this + "]";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.id == null) {
            throw new InvalidObjectException("id is null");
        }
        if (!this.hasConsistentConstraints()) {
            throw new InvalidObjectException("inconsistent constraints between underlying proxy and invocation handler");
        }
    }

    private static ClassLoader getProxyLoader(final Class proxyClass) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return proxyClass.getClassLoader();
            }
        });
    }

    static {
        $assertionsDisabled = !ActivatableInvocationHandler.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.activation.ActivatableInvocationHandler");
        constructorArgs = new Class[]{InvocationHandler.class};
        enableGrant = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.activation.enableActivateGrant"));
        try {
            getPtiMethod = ActivatableInvocationHandler.class.getDeclaredMethod("getProxyTrustIterator", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
    }

    private static class Failure {
        final Throwable exception;
        final boolean retry;

        Failure(Throwable exception, boolean retry) {
            this.exception = exception;
            this.retry = retry;
        }
    }
}

