/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.config.Config;
import java.text.DateFormat;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class WakeupManager {
    private static final String COMPONENT_NAME = "com.sun.jini.thread.WakeupManager";
    private static final long DEFAULT_QUEUE_THREAD_TIMEOUT = 30000L;
    private final long queueThreadTimeout;
    private final SortedSet contents = new TreeSet();
    private final ThreadDesc kickerDesc;
    private final Kicker kicker = new Kicker();
    private long nextBreaker = 0L;
    private Ticket head = null;
    private Thread kickerThread;
    private boolean dead = false;
    private static DateFormat dateFmt;
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WakeupManager() {
        this(new ThreadDesc());
    }

    public WakeupManager(ThreadDesc desc) {
        if (desc == null) {
            throw new NullPointerException("desc must be non-null");
        }
        this.kickerDesc = desc;
        this.queueThreadTimeout = 30000L;
    }

    public WakeupManager(ThreadDesc desc, Configuration config) throws ConfigurationException {
        if (desc == null) {
            throw new NullPointerException("desc must be non-null");
        }
        this.kickerDesc = desc;
        this.queueThreadTimeout = Config.getLongEntry(config, COMPONENT_NAME, "queueThreadTimeout", 30000L, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ticket newTicket(long when, Runnable task, ThreadDesc threadDesc) {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            return new Ticket(when, task, threadDesc, this.nextBreaker++);
        }
    }

    public Ticket schedule(long when, Runnable task) {
        return this.schedule(when, task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket schedule(long when, Runnable task, ThreadDesc threadDesc) {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            if (this.dead) {
                throw new IllegalStateException("trying to add task to stopped WakeupManager");
            }
            Ticket t = this.newTicket(when, task, threadDesc);
            this.contents.add(t);
            if (this.kickerThread == null) {
                logger.log(Level.FINEST, "starting queue's thread");
                this.kickerThread = this.kickerDesc.thread(this.kicker);
                this.kickerThread.start();
            }
            this.checkHead();
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Ticket t) {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            if (this.dead) {
                return;
            }
            this.contents.remove(t);
            this.checkHead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            if (this.dead) {
                return;
            }
            this.contents.clear();
            this.checkHead();
        }
    }

    private void checkHead() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.contents)) {
            throw new AssertionError();
        }
        Ticket oldHead = this.head;
        this.head = this.contents.isEmpty() ? null : (Ticket)this.contents.first();
        if (this.head == oldHead) {
            return;
        }
        this.contents.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            return this.contents.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SortedSet sortedSet = this.contents;
        synchronized (sortedSet) {
            this.contents.clear();
            this.kickerThread = null;
            this.head = null;
            this.dead = true;
            this.contents.notifyAll();
        }
    }

    static {
        $assertionsDisabled = !WakeupManager.class.desiredAssertionStatus();
        dateFmt = DateFormat.getTimeInstance(1);
        logger = Logger.getLogger(COMPONENT_NAME);
    }

    private class Kicker
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Kicker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long kickerExitTime = Long.MIN_VALUE;
            while (true) {
                Ticket ticketToRun;
                SortedSet sortedSet = WakeupManager.this.contents;
                synchronized (sortedSet) {
                    while (true) {
                        long timeToNextEvent;
                        if (WakeupManager.this.dead) {
                            return;
                        }
                        long now = System.currentTimeMillis();
                        if (WakeupManager.this.contents.isEmpty()) {
                            if (kickerExitTime == Long.MIN_VALUE && (kickerExitTime = now + WakeupManager.this.queueThreadTimeout) < 0L) {
                                kickerExitTime = Long.MAX_VALUE;
                            }
                            if ((timeToNextEvent = kickerExitTime - now) <= 0L) {
                                logger.log(Level.FINEST, "stopping queue's thread");
                                WakeupManager.this.kickerThread = null;
                                return;
                            }
                        } else {
                            kickerExitTime = Long.MIN_VALUE;
                            timeToNextEvent = ((WakeupManager)WakeupManager.this).head.when - now;
                            if (timeToNextEvent <= 0L) break;
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "timeToNextEvent:{0}", timeToNextEvent == Long.MAX_VALUE ? "Long.MAX_VALUE" : Long.toString(timeToNextEvent));
                        }
                        if (!$assertionsDisabled && timeToNextEvent <= 0L) {
                            throw new AssertionError();
                        }
                        try {
                            WakeupManager.this.contents.wait(timeToNextEvent);
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.INFO, "Queue's thread interrupted");
                            return;
                        }
                    }
                    ticketToRun = WakeupManager.this.head;
                    WakeupManager.this.contents.remove(WakeupManager.this.head);
                    WakeupManager.this.checkHead();
                }
                if (ticketToRun.desc == null) {
                    try {
                        ticketToRun.task.run();
                    }
                    catch (Throwable e) {
                        logger.log(Level.INFO, "Runnable.run exception", e);
                    }
                    continue;
                }
                ticketToRun.desc.thread(ticketToRun.task).start();
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$thread$WakeupManager == null ? (class$com$sun$jini$thread$WakeupManager = WakeupManager.class$(WakeupManager.COMPONENT_NAME)) : class$com$sun$jini$thread$WakeupManager).desiredAssertionStatus();
        }
    }

    public static class Ticket
    implements Comparable {
        public final long when;
        public final Runnable task;
        public final ThreadDesc desc;
        private final long breaker;

        private Ticket(long when, Runnable task, ThreadDesc threadDesc, long breaker) {
            if (task == null) {
                throw new NullPointerException("task not specified");
            }
            this.when = when;
            this.task = task;
            this.desc = threadDesc;
            this.breaker = breaker;
        }

        public String toString() {
            return dateFmt.format(new Long(this.when)) + "(" + this.when + ")" + ", " + this.task.getClass().getName() + ", " + this.desc;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Ticket)) {
                return false;
            }
            Ticket that = (Ticket)o;
            return that.when == this.when && that.breaker == this.breaker;
        }

        public int hashCode() {
            return (int)this.breaker;
        }

        public int compareTo(Object o) {
            Ticket that = (Ticket)o;
            long whenDiff = this.when - that.when;
            if (whenDiff > 0L) {
                return 1;
            }
            if (whenDiff < 0L) {
                return -1;
            }
            long breakerDiff = this.breaker - that.breaker;
            if (breakerDiff > 0L) {
                return 1;
            }
            if (breakerDiff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static class ThreadDesc {
        private final ThreadGroup group;
        private final boolean daemon;
        private final int priority;

        public ThreadDesc() {
            this(null, false);
        }

        public ThreadDesc(ThreadGroup group, boolean daemon) {
            this(group, daemon, 5);
        }

        public ThreadDesc(ThreadGroup group, boolean daemon, int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException("bad value for priority:" + priority);
            }
            this.group = group;
            this.daemon = daemon;
            this.priority = priority;
        }

        protected ThreadGroup getGroup() {
            return this.group;
        }

        protected boolean isDaemon() {
            return this.daemon;
        }

        protected int getPriority() {
            return this.priority;
        }

        protected Thread thread(Runnable r) {
            Thread thr = this.getGroup() == null ? new Thread(r) : new Thread(this.getGroup(), r);
            thr.setDaemon(this.isDaemon());
            thr.setPriority(this.getPriority());
            return thr;
        }

        public String toString() {
            return "[" + this.getGroup() + ", " + this.isDaemon() + ", " + this.getPriority() + "]";
        }
    }
}

