/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import net.jhorstmann.i18n.I18N;
import net.jhorstmann.i18n.LocaleProvider;
import net.jhorstmann.i18n.ResourceBundleProvider;
import net.jhorstmann.i18n.jsp.RequestLocaleProviderFactory;
import net.jhorstmann.i18n.jsp.RequestResourceBundleProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationTag
extends BodyTagSupport {
    private static final Logger log = LoggerFactory.getLogger(TranslationTag.class);
    private ResourceBundleProvider bundleProvider;
    private LocaleProvider localeProvider;
    private String context;
    private String message;
    private String plural;
    private Long num;
    private List params;

    public void release() {
        super.release();
        this.bundleProvider = null;
        this.localeProvider = null;
    }

    public int doStartTag() throws JspException {
        this.params = new ArrayList(2);
        if (this.bundleProvider == null) {
            this.bundleProvider = RequestResourceBundleProviderFactory.newInstance().newResourceBundleProvider();
        }
        if (this.localeProvider == null) {
            this.localeProvider = RequestLocaleProviderFactory.newInstance().newLocaleProvider();
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        BodyContent content;
        String msgid = this.getMessage();
        if (msgid == null && (content = this.getBodyContent()) != null) {
            msgid = content.getString().trim();
            content.clearBody();
        }
        if (msgid == null) {
            throw new JspTagException("No message given in TranslationTag");
        }
        Locale locale = this.localeProvider.getLocale();
        ResourceBundle bundle = this.bundleProvider.getResourceBundle(locale);
        if (log.isTraceEnabled()) {
            log.trace("localeProvider is {}", (Object)this.localeProvider);
            log.trace("locale is {}", (Object)locale);
            log.trace("bundleProvider is {}", (Object)this.bundleProvider);
            log.trace("bundle is {}", (Object)bundle);
            log.trace("context is '{}'", (Object)this.context);
            log.trace("message is '{}'" + this.message);
            log.trace("msgid is '{}'", (Object)msgid);
            log.trace("plural is '{}'", (Object)this.plural);
            log.trace("num is {}", (Object)this.num);
            log.trace("params is {}", (Object)this.params);
        }
        Object[] paramsArray = this.params == null ? new Object[]{} : this.params.toArray();
        long n = this.num == null ? 0L : this.num;
        String msg = I18N.translate((ResourceBundle)bundle, (String)this.context, (String)msgid, (String)this.plural, (long)n, (Object[])paramsArray);
        try {
            this.pageContext.getOut().print(msg);
        }
        catch (IOException ex) {
            throw new JspException((Throwable)ex);
        }
        this.context = null;
        this.message = null;
        this.plural = null;
        this.num = null;
        return 6;
    }

    public void addParam(Object param) {
        this.params.add(param);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getNum() {
        return this.num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String plural) {
        this.plural = plural;
    }
}

