/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.jsp;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import net.jhorstmann.i18n.ResourceBundleProvider;
import net.jhorstmann.i18n.jsp.I18nFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResourceBundleProvider
implements ResourceBundleProvider {
    private static final Logger log = LoggerFactory.getLogger(RequestResourceBundleProvider.class);

    static ResourceBundle loadBundle(String bundleName, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        log.debug("Loading ResourceBundle {} for locale {}", (Object)bundleName, (Object)locale);
        return ResourceBundle.getBundle(bundleName, locale, cl, control);
    }

    public static ResourceBundle getResourceBundle(HttpServletRequest req, Locale locale) {
        ResourceBundle bundle = (ResourceBundle)req.getAttribute("net.jhorstmann.i18n.ResourceBundle");
        if (bundle == null) {
            String bundleName = (String)req.getAttribute("net.jhorstmann.i18n.ResourceBundleName");
            if (bundleName != null) {
                bundle = RequestResourceBundleProvider.loadBundle(bundleName, locale);
                req.setAttribute("net.jhorstmann.i18n.ResourceBundle", (Object)bundle);
            } else {
                log.warn("No ResourceBundle name configured");
            }
        }
        return bundle;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        HttpServletRequest currentRequest = I18nFilter.getCurrentRequest();
        return RequestResourceBundleProvider.getResourceBundle(currentRequest, locale);
    }
}

