/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.xml;

import net.jhorstmann.i18n.tools.xml.DefaultContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class NestedContentHandler
extends DefaultContentHandler {
    private final XMLReader xmlreader;
    private HandlerChain handlers;

    public NestedContentHandler(NestedContentHandler parent) {
        this(parent.xmlreader);
    }

    public NestedContentHandler(XMLReader xmlreader, ContentHandler handler) {
        this.xmlreader = xmlreader;
        this.handlers = new HandlerChain(handler);
    }

    public NestedContentHandler(XMLReader xmlreader) {
        this.xmlreader = xmlreader;
    }

    public final XMLReader getXMLReader() {
        return this.xmlreader;
    }

    public final void pushHandler(ContentHandler handler) {
        this.handlers = new HandlerChain(handler, this.handlers);
        this.xmlreader.setContentHandler(handler);
        if (handler instanceof LexicalHandler) {
            try {
                this.xmlreader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotSupportedException ex) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
    }

    public final void popHandler() {
        if (this.handlers == null) {
            throw new IllegalStateException("No handlers on stack");
        }
        this.handlers = this.handlers.parent;
        this.xmlreader.setContentHandler(this.handlers.handler);
    }

    static class HandlerChain {
        ContentHandler handler;
        HandlerChain parent;

        HandlerChain(ContentHandler handler) {
            this.handler = handler;
        }

        HandlerChain(ContentHandler handler, HandlerChain parent) {
            this.handler = handler;
            this.parent = parent;
        }
    }
}

