/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.xml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public final class NamespaceContextImpl
implements NamespaceContext {
    private final LinkedList<PrefixMapping> namespaces = new LinkedList();

    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.addFirst(new PrefixMapping(prefix, uri));
    }

    public final void endPrefixMapping(String prefix) throws SAXException {
        Iterator it = this.namespaces.iterator();
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            if (!prefix.equals(mapping.prefix)) continue;
            it.remove();
            return;
        }
        throw new SAXException("End prefix mapping for unknown prefix '" + prefix + "'");
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (PrefixMapping mapping : this.namespaces) {
            if (!prefix.equals(mapping.prefix)) continue;
            return mapping.uri;
        }
        return "";
    }

    @Override
    public final String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (PrefixMapping mapping : this.namespaces) {
            if (!uri.equals(mapping.uri)) continue;
            return mapping.prefix;
        }
        return null;
    }

    public final Iterator getPrefixes(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singleton("xml").iterator();
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singleton("xmlns").iterator();
        }
        LinkedList<String> res = new LinkedList<String>();
        for (PrefixMapping mapping : this.namespaces) {
            if (!uri.equals(mapping.uri)) continue;
            res.add(mapping.prefix);
        }
        return Collections.unmodifiableCollection(res).iterator();
    }

    public final QName resolveQName(String name) {
        int idx = name.indexOf(58);
        if (idx == 0) {
            throw new IllegalArgumentException("Name must not start with a colon");
        }
        if (idx < 0) {
            return new QName("", name);
        }
        String prefix = name.substring(0, idx);
        String localName = name.substring(idx + 1);
        String uri = this.getNamespaceURI(prefix);
        return new QName(uri, localName, prefix);
    }

    static class PrefixMapping {
        String prefix;
        String uri;

        PrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

