/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.expr;

import net.jhorstmann.i18n.tools.expr.Expression;
import net.jhorstmann.i18n.tools.expr.InvalidExpressionException;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class TernaryExpression
extends Expression {
    private Expression ifExpr;
    private Expression thenExpr;
    private Expression elseExpr;

    public TernaryExpression(Expression ifExpr, Expression thenExpr, Expression elseExpr) {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    @Override
    public long eval(long n) {
        long cond = this.ifExpr.eval(n);
        return cond != 0L ? this.thenExpr.eval(n) : this.elseExpr.eval(n);
    }

    @Override
    public boolean isBool() {
        return this.thenExpr.isBool() && this.elseExpr.isBool();
    }

    @Override
    public void validate() throws InvalidExpressionException {
        if (!this.ifExpr.isBool()) {
            throw new InvalidExpressionException("Condition must be of boolean type");
        }
    }

    @Override
    public String toString() {
        return "(" + this.ifExpr + ") ? (" + this.thenExpr + ") : (" + this.elseExpr + ")";
    }

    @Override
    public void compile(GeneratorAdapter ga, int narg) {
        Label thenLabel = new Label();
        Label retLabel = new Label();
        this.ifExpr.compile(ga, narg);
        ga.push(0L);
        ga.ifCmp(Type.LONG_TYPE, 154, thenLabel);
        this.elseExpr.compile(ga, narg);
        ga.goTo(retLabel);
        ga.mark(thenLabel);
        this.thenExpr.compile(ga, narg);
        ga.mark(retLabel);
    }

    @Override
    public int computeStackSize() {
        return Math.max(2 + this.ifExpr.computeStackSize(), Math.max(this.thenExpr.computeStackSize(), this.elseExpr.computeStackSize()));
    }
}

