/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.expr;

import net.jhorstmann.i18n.tools.expr.Expression;
import net.jhorstmann.i18n.tools.expr.InvalidExpressionException;
import org.objectweb.asm.commons.GeneratorAdapter;

public class NotExpression
extends Expression {
    private Expression child;

    public NotExpression(Expression child) {
        this.child = child;
    }

    @Override
    public long eval(long n) {
        return this.child.eval(n) == 0L ? 1L : 0L;
    }

    @Override
    public boolean isBool() {
        return true;
    }

    @Override
    public void validate() throws InvalidExpressionException {
        if (!this.child.isBool()) {
            throw new InvalidExpressionException("Operator '!' can only be applied to boolean expressions");
        }
    }

    @Override
    public String toString() {
        return "!(" + this.child + ")";
    }

    @Override
    public void compile(GeneratorAdapter ga, int narg) {
        ga.not();
    }

    @Override
    public int computeStackSize() {
        return this.child.computeStackSize();
    }
}

