/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ResourceUtils {
    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        if (normalizedTargetPath.length() > common.length()) {
            relative.append(normalizedTargetPath.substring(common.length()));
        }
        return relative.toString();
    }

    static class PathResolutionException
    extends RuntimeException {
        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

