/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.fedorahosted.tennera.jgettext.HeaderFields;
import org.fedorahosted.tennera.jgettext.Message;

class MessageUtils {
    MessageUtils() {
    }

    public static String getPluralForms(Message header) {
        HeaderFields fields = HeaderFields.wrap((Message)header);
        return fields.getValue("Plural-Forms");
    }

    public static String serializeMsgid(String msgctx, String msgid) {
        if (msgid == null) {
            throw new IllegalArgumentException("msgid must not be null");
        }
        if (msgctx == null) {
            return msgid;
        }
        return msgctx + "\u0004" + msgid;
    }

    public static String serializeMsgid(Message msg) {
        String id = MessageUtils.serializeMsgid(msg.getMsgctxt(), msg.getMsgid());
        if (msg.isPlural()) {
            return id + "\u0000" + msg.getMsgidPlural();
        }
        return id;
    }

    public static String serializeMsgstr(Message message) {
        if (message.isPlural()) {
            StringBuilder sb = new StringBuilder();
            List plurals = message.getMsgstrPlural();
            Iterator it = plurals.iterator();
            while (it.hasNext()) {
                String plural = (String)it.next();
                sb.append(plural);
                if (!it.hasNext()) continue;
                sb.append("\u0000");
            }
            return sb.toString();
        }
        String msgstr = message.getMsgstr();
        return msgstr == null ? "" : msgstr;
    }

    public static byte[] serializeMsgstrUTF8(Message message) {
        try {
            return MessageUtils.serializeMsgstr(message).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError("utf-8 is a required encoding");
        }
    }

    public static byte[] serializeMsgidUTF8(Message message) {
        try {
            return MessageUtils.serializeMsgid(message).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError("utf-8 is a required encoding");
        }
    }
}

