/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import net.jhorstmann.i18n.tools.MessageUtils;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoParser;
import org.fedorahosted.tennera.jgettext.PoWriter;

public class MessageBundle
implements Iterable<Message> {
    private final LinkedHashMap<MessageBundleKey, Message> messages = new LinkedHashMap();
    private String basename;
    private String locale;
    private String pkgName;
    private String pkgVersion;
    private boolean template;
    private String footerComment;

    public static MessageBundleKey createKey(Message msg) {
        return new MessageBundleKey(msg.getMsgctxt(), msg.getMsgid());
    }

    public static MessageBundleKey createKey(String msgctx, String msgid) {
        return new MessageBundleKey(msgctx, msgid);
    }

    public static MessageBundleKey createKey(String msgid) {
        return new MessageBundleKey(msgid);
    }

    public static MessageBundle loadProperties(File file, String basename, String locale) throws IOException {
        org.fedorahosted.openprops.Properties props = new org.fedorahosted.openprops.Properties();
        props.load((InputStream)new FileInputStream(file));
        MessageBundle bundle = new MessageBundle(file.getName(), props);
        bundle.setBasename(basename);
        bundle.setLocale(locale);
        return bundle;
    }

    public static MessageBundle loadProperties(InputStream in) throws IOException {
        org.fedorahosted.openprops.Properties props = new org.fedorahosted.openprops.Properties();
        props.load(in);
        return new MessageBundle(props);
    }

    public static MessageBundle loadProperties(Reader reader) throws IOException {
        org.fedorahosted.openprops.Properties props = new org.fedorahosted.openprops.Properties();
        props.load(reader);
        return new MessageBundle(props);
    }

    public static MessageBundle loadCatalog(File file) throws IOException {
        Catalog catalog = new PoParser().parseCatalog(file);
        return new MessageBundle(catalog);
    }

    public MessageBundle(Catalog catalog) {
        for (Message msg : catalog) {
            this.addMessage(msg);
        }
    }

    public MessageBundle(org.fedorahosted.openprops.Properties props) {
        this(null, props);
    }

    public MessageBundle(String locale, org.fedorahosted.openprops.Properties props) {
        for (String key : props.keySet()) {
            String property = props.getProperty(key);
            String comment = props.getComment(key);
            Message msg = new Message();
            msg.setMsgid(key);
            msg.setMsgstr(property);
            msg.addComment(comment);
            this.addMessage(msg);
        }
    }

    public MessageBundle() {
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public final void addMessage(Message msg) {
        this.messages.put(MessageBundle.createKey(msg), msg);
    }

    public Message getMessage(String msgctx, String msgid) {
        return this.messages.get(MessageBundle.createKey(msgctx, msgid));
    }

    public Message getMessage(String msgid) {
        return this.messages.get(MessageBundle.createKey(msgid));
    }

    public Set<MessageBundleKey> getKeys() {
        return this.messages.keySet();
    }

    public Set<String> getMessageIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (MessageBundleKey key : this.messages.keySet()) {
            String id = MessageUtils.serializeMsgid(key.getMsgctx(), key.getMsgid());
            ids.add(id);
        }
        return ids;
    }

    public Message getHeaderMessage() {
        return this.getMessage("");
    }

    public String getPluralForms() {
        Message header = this.getHeaderMessage();
        if (header == null) {
            return null;
        }
        return MessageUtils.getPluralForms(header);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.values().iterator();
    }

    public Catalog toCatalog(boolean template) {
        Catalog catalog = new Catalog(template);
        for (Message message : this.messages.values()) {
            catalog.addMessage(message);
        }
        return catalog;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Message message : this.messages.values()) {
            String id = MessageUtils.serializeMsgid(message);
            String str = MessageUtils.serializeMsgstr(message);
            props.setProperty(id, str);
        }
        return props;
    }

    public org.fedorahosted.openprops.Properties toOpenProps() {
        org.fedorahosted.openprops.Properties props = new org.fedorahosted.openprops.Properties();
        for (Message message : this.messages.values()) {
            String id = MessageUtils.serializeMsgid(message);
            String str = MessageUtils.serializeMsgstr(message);
            props.setProperty(id, str);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCatalog(File file) throws IOException {
        Catalog catalog = this.toCatalog(this.template);
        PoWriter pw = new PoWriter();
        pw.setGenerateHeader(!this.template);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            pw.write(catalog, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperties(File file) throws IOException {
        org.fedorahosted.openprops.Properties props = this.toOpenProps();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            props.store((OutputStream)fos, null);
        }
        finally {
            fos.close();
        }
    }

    public static final class MessageBundleKey {
        private final String msgctx;
        private final String msgid;
        private final int hash;

        public MessageBundleKey(String msgid) {
            this(null, msgid);
        }

        public MessageBundleKey(String msgctx, String msgid) {
            this.msgctx = msgctx;
            this.msgid = msgid;
            this.hash = MessageBundleKey.createHash(msgctx, msgid);
        }

        private static int createHash(String msgctx, String msgid) {
            int hash = 7;
            if (msgctx != null) {
                hash = hash * 31 + msgctx.hashCode();
            }
            if (msgid != null) {
                hash = hash * 31 + msgid.hashCode();
            }
            return hash;
        }

        public String getMsgctx() {
            return this.msgctx;
        }

        public String getMsgid() {
            return this.msgid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MessageBundleKey)) {
                return false;
            }
            MessageBundleKey other = (MessageBundleKey)obj;
            if (this.msgctx == null ? other.msgctx != null : !this.msgctx.equals(other.msgctx)) {
                return false;
            }
            return !(this.msgid == null ? other.msgid != null : !this.msgid.equals(other.msgid));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

