// $ANTLR 2.7.7 (20060906): "expr.g" -> "ExprParser.java"$

package net.jhorstmann.i18n.tools;

import net.jhorstmann.i18n.tools.*;
import net.jhorstmann.i18n.tools.expr.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

public class ExprParser extends antlr.LLkParser       implements ExprParserTokenTypes
 {

protected ExprParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public ExprParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected ExprParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public ExprParser(TokenStream lexer) {
  this(lexer,1);
}

public ExprParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final Expression  expression() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		
		r=or_expr();
		match(Token.EOF_TYPE);
		return r;
	}
	
	public final Expression  or_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=and_expr();
		{
		_loop64:
		do {
			if ((LA(1)==OR)) {
				match(OR);
				e=and_expr();
				r = new OrExpression(r, e);
			}
			else {
				break _loop64;
			}
			
		} while (true);
		}
		return r;
	}
	
	public final Expression  and_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=neg_expr();
		{
		_loop67:
		do {
			if ((LA(1)==AND)) {
				match(AND);
				e=neg_expr();
				r = new AndExpression(r, e);
			}
			else {
				break _loop67;
			}
			
		} while (true);
		}
		return r;
	}
	
	public final Expression  neg_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		switch ( LA(1)) {
		case NOT:
		{
			match(NOT);
			e=prim_expr();
			r = new NotExpression(e);
			break;
		}
		case BOOL:
		case OPEN:
		{
			r=prim_expr();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return r;
	}
	
	public final Expression  prim_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Token  b = null;
		Expression e = null;
		
		switch ( LA(1)) {
		case BOOL:
		{
			b = LT(1);
			match(BOOL);
			r = new ConstantExpression(Integer.parseInt(b.getText()));
			break;
		}
		case OPEN:
		{
			match(OPEN);
			e=or_expr();
			match(CLOSE);
			r = e;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return r;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"OR",
		"AND",
		"NOT",
		"BOOL",
		"OPEN",
		"CLOSE",
		"WS"
	};
	
	
	}
