/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.xgettext;

import java.io.File;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import net.jhorstmann.i18n.tools.MessageBundle;
import net.jhorstmann.i18n.tools.ResourceUtils;
import net.jhorstmann.i18n.tools.xml.NamespaceContextImpl;
import net.jhorstmann.i18n.tools.xml.NestedContentHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.fedorahosted.tennera.jgettext.Message;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AbstractExtractorHandler
extends NestedContentHandler
implements Locator,
NamespaceContext {
    private final NamespaceContextImpl namespaceContext;
    private final MessageBundle bundle;
    private Locator locator;
    private boolean relativizePaths;
    File rootDir;

    public AbstractExtractorHandler(XMLReader xmlreader, MessageBundle bundle) {
        this(xmlreader, bundle, null, false);
    }

    public AbstractExtractorHandler(XMLReader xmlreader, MessageBundle bundle, File rootDir, boolean relativizePaths) {
        super(xmlreader);
        this.bundle = bundle;
        this.namespaceContext = new NamespaceContextImpl();
        this.relativizePaths = relativizePaths;
        this.rootDir = rootDir;
    }

    private Message createMessage(String msgid) {
        String systemId;
        Message msg = new Message();
        if (this.locator != null && (systemId = this.locator.getSystemId()) != null) {
            int line;
            if (this.relativizePaths && this.rootDir != null) {
                try {
                    systemId = URLDecoder.decode(systemId, "UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                Pattern ptnProtocol = Pattern.compile("([a-zA-Z]+://)");
                Matcher m = ptnProtocol.matcher(systemId);
                String protocol = "";
                if (m.find()) {
                    protocol = m.group(0);
                }
                int idx = StringUtils.isEmpty((String)protocol) ? -1 : systemId.lastIndexOf(protocol);
                String cleanRef = (idx != -1 ? systemId.substring(idx + protocol.length()) : systemId).replace(protocol, "");
                String fileName = FilenameUtils.getName((String)cleanRef);
                String filePath = FilenameUtils.getFullPath((String)cleanRef);
                if (filePath.startsWith("/") && filePath.contains(":")) {
                    filePath = filePath.substring(1);
                }
                systemId = ResourceUtils.getRelativePath(filePath + fileName, FilenameUtils.separatorsToUnix((String)this.rootDir.getAbsolutePath()), "/");
            }
            if ((line = this.locator.getLineNumber()) > 0) {
                msg.addSourceReference(systemId, line);
            } else {
                msg.addSourceReference(systemId);
            }
        }
        msg.setMsgid(msgid);
        return msg;
    }

    public Message addMessage(String msgid) {
        Message msg = this.createMessage(msgid);
        msg.setMsgstr(msgid);
        this.bundle.addMessage(msg);
        return msg;
    }

    public Message addMessage(String context, String message, String plural, String comment) {
        if (message == null) {
            throw new IllegalArgumentException("Message id must not be null");
        }
        Message msg = this.createMessage(message);
        if (context != null && context.length() > 0) {
            msg.setMsgctxt(context);
        }
        if (plural != null && plural.length() > 0) {
            msg.setMsgidPlural(plural);
            msg.addMsgstrPlural("", 0);
        }
        if (comment != null && comment.length() > 0) {
            msg.addExtractedComment(comment);
        }
        this.bundle.addMessage(msg);
        return msg;
    }

    public Message addMessageWithContext(String msgctx, String msgid) {
        Message msg = this.createMessage(msgid);
        msg.setMsgctxt(msgctx);
        this.bundle.addMessage(msg);
        return msg;
    }

    public Message addMessageWithPlural(String msgidSingular, String msgidPlural) {
        Message msg = this.createMessage(msgidSingular);
        msg.setMsgidPlural(msgidPlural);
        this.bundle.addMessage(msg);
        return msg;
    }

    public Message addMessageWithContextAndPlural(String msgctx, String msgidSingular, String msgidPlural) {
        Message msg = this.createMessage(msgidSingular);
        msg.setMsgctxt(msgctx);
        msg.setMsgidPlural(msgidPlural);
        this.bundle.addMessage(msg);
        return msg;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceContext.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceContext.endPrefixMapping(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaceContext.getPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return this.namespaceContext.getPrefixes(namespaceURI);
    }

    public QName resolveQName(String name) {
        return this.namespaceContext.resolveQName(name);
    }

    @Override
    public int getLineNumber() {
        return this.locator != null ? this.locator.getLineNumber() : -1;
    }

    @Override
    public int getColumnNumber() {
        return this.locator != null ? this.locator.getColumnNumber() : -1;
    }

    @Override
    public String getSystemId() {
        return this.locator != null ? this.locator.getSystemId() : null;
    }

    @Override
    public String getPublicId() {
        return this.locator != null ? this.locator.getPublicId() : null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

