/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.expr;

import net.jhorstmann.i18n.tools.expr.Expression;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public abstract class BinaryExpression
extends Expression {
    protected final Expression leftExpr;
    protected final Expression rightExpr;

    public BinaryExpression(Expression leftExpr, Expression rightExpr) {
        this.leftExpr = leftExpr;
        this.rightExpr = rightExpr;
    }

    protected String toString(String op) {
        return "(" + this.leftExpr + ") " + op + " (" + this.rightExpr + ")";
    }

    protected void compileBinaryInstruction(GeneratorAdapter ga, int narg, int insn) {
        this.leftExpr.compile(ga, narg);
        this.rightExpr.compile(ga, narg);
        ga.math(insn, Type.LONG_TYPE);
    }

    @Override
    public int computeStackSize() {
        return Math.max(this.leftExpr.computeStackSize(), 2 + this.rightExpr.computeStackSize());
    }
}

