/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools.expr;

import net.jhorstmann.i18n.tools.expr.BinaryExpression;
import net.jhorstmann.i18n.tools.expr.Expression;
import net.jhorstmann.i18n.tools.expr.InvalidExpressionException;
import org.objectweb.asm.commons.GeneratorAdapter;

public class AndExpression
extends BinaryExpression {
    public AndExpression(Expression leftExpr, Expression rightExpr) {
        super(leftExpr, rightExpr);
    }

    @Override
    public long eval(long n) {
        return this.leftExpr.eval(n) != 0L && this.rightExpr.eval(n) != 0L ? 1L : 0L;
    }

    @Override
    public boolean isBool() {
        return true;
    }

    @Override
    public void validate() throws InvalidExpressionException {
        if (!this.leftExpr.isBool()) {
            throw new InvalidExpressionException("Left child expression must be of boolean type");
        }
        if (!this.rightExpr.isBool()) {
            throw new InvalidExpressionException("Right child expression must be of boolean type");
        }
    }

    @Override
    public String toString() {
        return this.toString("&&");
    }

    @Override
    public void compile(GeneratorAdapter ga, int narg) {
        this.compileBinaryInstruction(ga, narg, 126);
    }
}

