/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import net.jhorstmann.i18n.tools.MessageBundle;
import net.jhorstmann.i18n.tools.PluralForms;
import net.jhorstmann.i18n.tools.PluralsParser;
import net.jhorstmann.i18n.tools.expr.Expression;
import org.fedorahosted.tennera.jgettext.Message;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public class ResourceBundleCompiler {
    private static final String CONTEXT_GLUE = "\u0004";
    private static final String DEFAULT_PARENT_CLASS = ResourceBundle.class.getName();

    public static byte[] compile(MessageBundle bundle, String className) {
        return ResourceBundleCompiler.compile(bundle, DEFAULT_PARENT_CLASS, className);
    }

    public static void compileFile(MessageBundle bundle, String className, File dir) throws IOException {
        ResourceBundleCompiler.compileFile(bundle, DEFAULT_PARENT_CLASS, className, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileFile(MessageBundle bundle, String parentClassName, String className, File dir) throws IOException {
        File file = new File(dir, className.replace('.', '/') + ".class");
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Could not create directory " + parent);
        }
        byte[] bytes = ResourceBundleCompiler.compile(bundle, parentClassName, className);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(bytes);
        }
        finally {
            fos.close();
        }
    }

    static Class<ResourceBundle> compileAndLoad(MessageBundle bundle, String className) throws InstantiationException, IllegalAccessException {
        return ResourceBundleCompiler.compileAndLoad(bundle, DEFAULT_PARENT_CLASS, className, null);
    }

    static Class<ResourceBundle> compileAndLoad(MessageBundle bundle, String parentClassName, String className, ClassLoader parent) throws InstantiationException, IllegalAccessException {
        byte[] bytes = ResourceBundleCompiler.compile(bundle, parentClassName, className);
        return new MyClassLoader(parent).defineClass(className, bytes);
    }

    public static byte[] compile(MessageBundle bundle, String parentClassName, String className) {
        ClassWriter cw = new ClassWriter(2);
        CheckClassAdapter ca = new CheckClassAdapter((ClassVisitor)cw, true);
        ResourceBundleCompiler.compile((ClassVisitor)ca, bundle, parentClassName, className);
        return cw.toByteArray();
    }

    static void compile(ClassVisitor cv, MessageBundle bundle, String parentClassName, String className) {
        String parent = parentClassName.replace('.', '/');
        String owner = className.replace('.', '/');
        cv.visit(46, 1, owner, null, parent, null);
        cv.visitField(10, "messages", "Ljava/util/HashMap;", null, null);
        ResourceBundleCompiler.compileStaticInit(cv, owner, bundle);
        ResourceBundleCompiler.compileConstructor(cv, parent);
        ResourceBundleCompiler.compileGetParent(cv, parent);
        ResourceBundleCompiler.compileLookup(cv, owner);
        ResourceBundleCompiler.compileGetKeys(cv, owner);
        ResourceBundleCompiler.compileHandleGetObject(cv, owner);
        String pluralForms = bundle.getPluralForms();
        if (pluralForms != null) {
            ResourceBundleCompiler.compilePluralEval(cv, pluralForms);
            ResourceBundleCompiler.compilePluralIndex(cv, owner);
        } else {
            ResourceBundleCompiler.compilePluralIndexDummy(cv, owner);
        }
        cv.visitEnd();
    }

    private static void compileHandleGetObject(ClassVisitor cv, String owner) {
        MethodVisitor mv = cv.visitMethod(1, "handleGetObject", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, owner, "lookup", "(Ljava/lang/String;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void compileGetKeys(ClassVisitor cv, String owner) {
        MethodVisitor mv = cv.visitMethod(1, "getKeys", "()Ljava/util/Enumeration;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, owner, "messages", "Ljava/util/HashMap;");
        mv.visitMethodInsn(185, "java/util/Map", "keySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(184, "java/util/Collections", "enumeration", "(Ljava/util/Collection;)Ljava/util/Enumeration;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void compileLookup(ClassVisitor cv, String owner) {
        MethodVisitor mv = cv.visitMethod(1, "lookup", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, owner, "messages", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void compileGetParent(ClassVisitor cv, String parent) {
        MethodVisitor mv = cv.visitMethod(1, "getParent", "()Ljava/util/ResourceBundle;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, parent, "parent", "Ljava/util/ResourceBundle;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void compileConstructor(ClassVisitor cv, String parent) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parent, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void compileStaticInit(ClassVisitor cv, String owner, MessageBundle bundle) {
        Label localMapBegin = new Label();
        Label localMapEnd = new Label();
        Label localArrayBegin = new Label();
        Label localArrayEnd = new Label();
        MethodVisitor mv = cv.visitMethod(9, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLabel(localMapBegin);
        mv.visitTypeInsn(187, "java/util/HashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        mv.visitVarInsn(58, 0);
        mv.visitLabel(localArrayBegin);
        for (Message message : bundle) {
            String msgctx = message.getMsgctxt();
            String msgid = (msgctx != null ? msgctx + CONTEXT_GLUE : "") + message.getMsgid();
            mv.visitVarInsn(25, 0);
            if (message.isPlural()) {
                List<String> plurals;
                List<String> list = plurals = bundle.isTemplate() ? Arrays.asList(msgid, message.getMsgidPlural()) : message.getMsgstrPlural();
                if (plurals.isEmpty()) {
                    mv.visitInsn(1);
                    mv.visitLdcInsn((Object)msgid);
                } else {
                    mv.visitLdcInsn((Object)plurals.size());
                    mv.visitTypeInsn(189, "java/lang/String");
                    mv.visitVarInsn(58, 1);
                    int i = 0;
                    for (String plural : plurals) {
                        mv.visitVarInsn(25, 1);
                        mv.visitLdcInsn((Object)i);
                        mv.visitLdcInsn((Object)plural);
                        mv.visitInsn(83);
                        ++i;
                    }
                    mv.visitLdcInsn((Object)msgid);
                    mv.visitVarInsn(25, 1);
                }
            } else {
                String msgstr;
                String string = msgstr = bundle.isTemplate() ? message.getMsgid() : message.getMsgstr();
                if (msgstr == null || msgstr.length() == 0) {
                    mv.visitLdcInsn((Object)msgid);
                    mv.visitInsn(1);
                } else {
                    mv.visitLdcInsn((Object)msgid);
                    mv.visitLdcInsn((Object)msgstr);
                }
            }
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
        }
        mv.visitLabel(localArrayEnd);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(179, owner, "messages", "Ljava/util/HashMap;");
        mv.visitLabel(localMapEnd);
        mv.visitInsn(177);
        mv.visitLocalVariable("array", "[Ljava/lang/Object;", null, localArrayBegin, localArrayEnd, 1);
        mv.visitLocalVariable("map", "Ljava/util/Map;", null, localMapBegin, localMapEnd, 0);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
    }

    private static void compilePluralEval(ClassVisitor cv, String pluralForms) {
        try {
            PluralForms pf = PluralsParser.parsePluralForms(pluralForms);
            Expression expr = pf.getExpression();
            MethodVisitor mv = cv.visitMethod(9, "pluralEval", "(J)J", null, null);
            GeneratorAdapter ga = new GeneratorAdapter(mv, 9, "pluralEval", "(J)J");
            ga.visitCode();
            expr.compile(ga, 0);
            ga.returnValue();
            int stack = expr.computeStackSize();
            ga.visitMaxs(stack, 2);
            ga.visitEnd();
        }
        catch (RecognitionException ex) {
            throw new IllegalStateException(ex);
        }
        catch (TokenStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void compilePluralIndex(ClassVisitor cv, String owner) {
        MethodVisitor mv = cv.visitMethod(1, "pluralIndex", "(J)I", null, null);
        mv.visitCode();
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(184, owner, "pluralEval", "(J)J");
        mv.visitInsn(136);
        mv.visitInsn(172);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private static void compilePluralIndexDummy(ClassVisitor cv, String owner) {
        MethodVisitor mv = cv.visitMethod(1, "pluralIndex", "(J)I", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(1, 3);
        mv.visitEnd();
    }

    static class MyClassLoader
    extends ClassLoader {
        MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        final Class<?> defineClass(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

