/*
 * Decompiled with CFR 0.152.
 */
package net.jhorstmann.i18n.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jhorstmann.i18n.tools.MessageBundle;
import org.fedorahosted.tennera.jgettext.Message;

public class MoParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBundle parseMessages(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            MessageBundle bundle;
            MessageBundle messageBundle = bundle = MoParser.parseMessages(in);
            return messageBundle;
        }
        finally {
            in.close();
        }
    }

    public static MessageBundle parseMessages(InputStream in) throws IOException {
        int i;
        int off;
        boolean big;
        int magic = MoParser.readInt(in, false);
        if (magic == -1794895138) {
            big = false;
        } else if (magic == -569244523) {
            big = true;
        } else {
            throw new IOException("Invalid magic number");
        }
        int rev = MoParser.readInt(in, big);
        int size = MoParser.readInt(in, big);
        int msgidTableOff = MoParser.readInt(in, big);
        int msgstrTableOff = MoParser.readInt(in, big);
        int hashSize = MoParser.readInt(in, big);
        int hashOff = MoParser.readInt(in, big);
        int[] msgidLength = new int[size];
        int[] msgidOffset = new int[size];
        int[] msgstrLength = new int[size];
        int[] msgstrOffset = new int[size];
        String[] msgid = new String[size];
        String[] msgstr = new String[size];
        for (off = 28; off < msgidTableOff; ++off) {
            MoParser.readNoEOF(in);
        }
        for (i = 0; i < size; ++i) {
            msgidLength[i] = MoParser.readInt(in, big);
            msgidOffset[i] = MoParser.readInt(in, big);
            off += 8;
        }
        while (off < msgstrTableOff) {
            MoParser.readNoEOF(in);
            ++off;
        }
        for (i = 0; i < size; ++i) {
            msgstrLength[i] = MoParser.readInt(in, big);
            msgstrOffset[i] = MoParser.readInt(in, big);
            off += 8;
        }
        while (off < hashOff + hashSize * 4) {
            MoParser.readNoEOF(in);
            ++off;
        }
        while (off < msgidOffset[0]) {
            MoParser.readNoEOF(in);
            ++off;
        }
        for (i = 0; i < size; ++i) {
            if (off != msgidOffset[i]) {
                throw new IOException("Offset for msgid " + i + " does not match, expected 0x" + Integer.toHexString(msgidOffset[i]) + " but was 0x" + Integer.toHexString(off));
            }
            msgid[i] = MoParser.readString(in, msgidLength[i]);
            off += msgidLength[i] + 1;
        }
        while (off < msgstrOffset[0]) {
            MoParser.readNoEOF(in);
            ++off;
        }
        for (i = 0; i < size; ++i) {
            if (off != msgstrOffset[i]) {
                throw new IOException("Offset for msgstr " + i + " does not match, expected 0x" + Integer.toHexString(msgstrOffset[i]) + " but was 0x" + Integer.toHexString(off));
            }
            msgstr[i] = MoParser.readString(in, msgstrLength[i]);
            off += msgstrLength[i] + 1;
        }
        MessageBundle bundle = new MessageBundle();
        for (int i2 = 0; i2 < size; ++i2) {
            String str;
            String plid;
            String id;
            String ctx;
            Message message = new Message();
            int idx = msgid[i2].indexOf(4);
            if (idx >= 0) {
                ctx = msgid[i2].substring(0, idx);
                id = msgid[i2].substring(idx + 1);
            } else {
                ctx = null;
                id = msgid[i2];
            }
            idx = id.indexOf(0);
            if (idx >= 0) {
                plid = id.substring(idx + 1);
                id = id.substring(0, idx);
            } else {
                plid = null;
            }
            message.setMsgid(id);
            if (ctx != null) {
                message.setMsgctxt(ctx);
            }
            if (plid != null) {
                message.setMsgidPlural(plid);
            }
            if ((idx = (str = msgstr[i2]).indexOf(0)) >= 0 && plid != null) {
                String plural;
                int lastidx = 0;
                int pos = 0;
                do {
                    plural = str.substring(lastidx, idx);
                    message.addMsgstrPlural(plural, pos);
                    ++pos;
                } while ((idx = str.indexOf(0, lastidx = idx + 1)) >= 0);
                plural = str.substring(lastidx);
                message.addMsgstrPlural(plural, pos);
            } else {
                message.setMsgstr(str);
            }
            bundle.addMessage(message);
        }
        return bundle;
    }

    private static int readNoEOF(InputStream in) throws IOException {
        int i = in.read();
        if (i < 0) {
            throw new IOException("EOF");
        }
        return i;
    }

    private static int readInt(InputStream in, boolean bigEndian) throws IOException {
        int b0 = MoParser.readNoEOF(in);
        int b1 = MoParser.readNoEOF(in);
        int b2 = MoParser.readNoEOF(in);
        int b3 = MoParser.readNoEOF(in);
        if (bigEndian) {
            return b0 << 24 | b1 << 16 | b2 << 8 | b3;
        }
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    private static String readString(InputStream in, int len) throws IOException {
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)(MoParser.readNoEOF(in) & 0xFF);
        }
        int end = MoParser.readNoEOF(in);
        if (end != 0) {
            throw new IOException("Expected NUL terminator for string but got 0x" + Integer.toHexString(end));
        }
        return new String(buf, 0, len, "utf-8");
    }
}

