// $ANTLR 2.7.7 (20060906): "plurals.g" -> "PluralsParser.java"$

package net.jhorstmann.i18n.tools;

import antlr.RecognitionException;
import antlr.TokenStreamException;

import java.io.StringReader;

import net.jhorstmann.i18n.tools.*;
import net.jhorstmann.i18n.tools.expr.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

public class PluralsParser extends antlr.LLkParser       implements PluralsParserTokenTypes
 {

    public static Expression parseExpression(String str) throws RecognitionException, TokenStreamException {
        PluralsLexer lexer = new PluralsLexer(new StringReader(str));
        PluralsParser parser = new PluralsParser(lexer);
        return parser.expression();
    }

    public static PluralForms parsePluralForms(String str) throws RecognitionException, TokenStreamException {
        PluralsLexer lexer = new PluralsLexer(new StringReader(str));
        PluralsParser parser = new PluralsParser(lexer);
        return parser.plurals();
    }

protected PluralsParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public PluralsParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected PluralsParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public PluralsParser(TokenStream lexer) {
  this(lexer,1);
}

public PluralsParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final PluralForms  plurals() throws RecognitionException, TokenStreamException {
		PluralForms pf = null;
		
		int i; Expression e = null;
		
		i=nplurals();
		match(SEMI);
		e=plural();
		{
		_loop3:
		do {
			if ((LA(1)==SEMI)) {
				match(SEMI);
			}
			else {
				break _loop3;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
		pf = new PluralForms(i, e);
		return pf;
	}
	
	public final int  nplurals() throws RecognitionException, TokenStreamException {
		int n = 0;
		
		Token  i = null;
		
		match(NPLURALS);
		match(ASSIGN);
		i = LT(1);
		match(INT);
		n = Integer.parseInt(i.getText());
		return n;
	}
	
	public final Expression  plural() throws RecognitionException, TokenStreamException {
		Expression e = null;
		
		
		match(PLURAL);
		match(ASSIGN);
		e=root_expr();
		return e;
	}
	
	public final Expression  root_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		
		r=ternary_expr();
		return r;
	}
	
	public final Expression  expression() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		
		r=root_expr();
		match(Token.EOF_TYPE);
		return r;
	}
	
	public final Expression  ternary_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e1 = null, e2 = null;
		
		r=or_expr();
		{
		_loop10:
		do {
			if ((LA(1)==QUEST)) {
				match(QUEST);
				e1=ternary_expr();
				match(COLON);
				e2=ternary_expr();
				r = new TernaryExpression(r, e1, e2);
			}
			else {
				break _loop10;
			}
			
		} while (true);
		}
		return r;
	}
	
	public final Expression  or_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=and_expr();
		{
		_loop13:
		do {
			if ((LA(1)==OR)) {
				match(OR);
				e=and_expr();
				r = new OrExpression(r, e);
			}
			else {
				break _loop13;
			}
			
		} while (true);
		}
		return r;
	}
	
	public final Expression  and_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=eq_expr();
		{
		_loop16:
		do {
			if ((LA(1)==AND)) {
				match(AND);
				e=eq_expr();
				r = new AndExpression(r, e);
			}
			else {
				break _loop16;
			}
			
		} while (true);
		}
		return r;
	}
	
	public final Expression  eq_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=cmp_expr();
		{
		_loop19:
		do {
			switch ( LA(1)) {
			case EQ:
			{
				match(EQ);
				e=cmp_expr();
				r = new CmpEqExpression(r, e);
				break;
			}
			case NE:
			{
				match(NE);
				e=cmp_expr();
				r = new CmpNeExpression(r, e);
				break;
			}
			default:
			{
				break _loop19;
			}
			}
		} while (true);
		}
		return r;
	}
	
	public final Expression  cmp_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=add_expr();
		{
		_loop22:
		do {
			switch ( LA(1)) {
			case LT:
			{
				match(LT);
				e=add_expr();
				r = new CmpLtExpression(r, e);
				break;
			}
			case LE:
			{
				match(LE);
				e=add_expr();
				r = new CmpLeExpression(r, e);
				break;
			}
			case GT:
			{
				match(GT);
				e=add_expr();
				r = new CmpGtExpression(r, e);
				break;
			}
			case GE:
			{
				match(GE);
				e=add_expr();
				r = new CmpGeExpression(r, e);
				break;
			}
			default:
			{
				break _loop22;
			}
			}
		} while (true);
		}
		return r;
	}
	
	public final Expression  add_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=mul_expr();
		{
		_loop25:
		do {
			switch ( LA(1)) {
			case ADD:
			{
				match(ADD);
				e=mul_expr();
				r = new AddExpression(r, e);
				break;
			}
			case SUB:
			{
				match(SUB);
				e=mul_expr();
				r = new SubExpression(r, e);
				break;
			}
			default:
			{
				break _loop25;
			}
			}
		} while (true);
		}
		return r;
	}
	
	public final Expression  mul_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		r=neg_expr();
		{
		_loop28:
		do {
			switch ( LA(1)) {
			case MUL:
			{
				match(MUL);
				e=neg_expr();
				r = new MulExpression(r, e);
				break;
			}
			case DIV:
			{
				match(DIV);
				e=neg_expr();
				r = new DivExpression(r, e);
				break;
			}
			case MOD:
			{
				match(MOD);
				e=neg_expr();
				r = new ModExpression(r, e);
				break;
			}
			default:
			{
				break _loop28;
			}
			}
		} while (true);
		}
		return r;
	}
	
	public final Expression  neg_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Expression e = null;
		
		switch ( LA(1)) {
		case NOT:
		{
			match(NOT);
			e=prim_expr();
			r = new NotExpression(e);
			break;
		}
		case INT:
		case NUM:
		case OPEN:
		{
			r=prim_expr();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return r;
	}
	
	public final Expression  prim_expr() throws RecognitionException, TokenStreamException {
		Expression r = null;
		
		Token  i = null;
		Expression e = null;
		
		switch ( LA(1)) {
		case INT:
		{
			i = LT(1);
			match(INT);
			r = new ConstantExpression(Integer.parseInt(i.getText()));
			break;
		}
		case NUM:
		{
			match(NUM);
			r = new VariableExpression();
			break;
		}
		case OPEN:
		{
			match(OPEN);
			e=root_expr();
			match(CLOSE);
			r = e;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return r;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"SEMI",
		"NPLURALS",
		"ASSIGN",
		"INT",
		"PLURAL",
		"QUEST",
		"COLON",
		"OR",
		"AND",
		"EQ",
		"NE",
		"LT",
		"LE",
		"GT",
		"GE",
		"ADD",
		"SUB",
		"MUL",
		"DIV",
		"MOD",
		"NOT",
		"NUM",
		"OPEN",
		"CLOSE",
		"WS"
	};
	
	
	}
