/*
 * Decompiled with CFR 0.152.
 */
package net.je2sh.asciitable;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.je2sh.asciitable.ContentParser;
import net.je2sh.asciitable.JCol;
import net.je2sh.asciitable.JRow;
import net.je2sh.asciitable.PlainContextParser;
import net.je2sh.asciitable.style.Chars;
import net.je2sh.asciitable.style.JTheme;
import org.apache.commons.lang3.StringUtils;

public class JTable {
    private List<JRow> rows = new ArrayList<JRow>();
    private int width = 100;
    private JTheme theme = JTheme.SINGLE_LINE;
    private ContentParser contentParser = new PlainContextParser();

    public static JTable of() {
        return new JTable();
    }

    public JRow row() {
        JRow newRow = new JRow(this);
        this.rows.add(newRow);
        return newRow;
    }

    public JTable width(int width) {
        this.width = width;
        return this;
    }

    public JTable theme(JTheme theme) {
        this.theme = theme;
        return this;
    }

    public JTable contentParser(ContentParser contentParser) {
        this.contentParser = contentParser;
        return this;
    }

    public List<String> render() {
        ArrayList<String> result = new ArrayList<String>();
        int[] colSizes = null;
        for (JRow row : this.rows) {
            int[] previousColSizes = colSizes;
            colSizes = this.colSizes(this.width, row.getCols());
            String topBorder = JTable.renderTopBorder(colSizes, previousColSizes, this.width, this.theme);
            if (!topBorder.trim().isEmpty()) {
                result.add(topBorder);
            }
            ArrayList<RenderedCol> colResult = new ArrayList<RenderedCol>();
            int maxHeight = 0;
            Iterator<JCol> colIter = row.getCols().iterator();
            int colIdx = 0;
            while (colIter.hasNext()) {
                JCol col = colIter.next();
                int widthToUse = colSizes[colIdx];
                RenderedCol renderedCol = new RenderedCol(col, widthToUse, col.render(this.theme, widthToUse));
                maxHeight = Math.max(maxHeight, renderedCol.getHeight());
                colResult.add(renderedCol);
                ++colIdx;
            }
            int finalMaxHeight = maxHeight;
            List colLines = colResult.stream().map(cr -> cr.getCol().render(this.theme, ((RenderedCol)cr).widthToUse, finalMaxHeight)).collect(Collectors.toList());
            for (int rowNum = 0; rowNum < finalMaxHeight; ++rowNum) {
                StringBuilder rowBuilder = new StringBuilder();
                for (List colLine : colLines) {
                    rowBuilder.append((String)colLine.get(rowNum));
                }
                JTable.safeAppend(rowBuilder, this.theme.vertical);
                result.add(rowBuilder.toString());
            }
        }
        String bottomBorder = JTable.renderBottomBorder(colSizes, this.theme);
        if (!bottomBorder.trim().isEmpty()) {
            result.add(bottomBorder);
        }
        return result;
    }

    private int[] colSizes(int tableWidth, List<JCol> cols) {
        int rowWidth;
        int[] result = new int[cols.size()];
        int remainingWidth = tableWidth;
        ArrayList<Integer> dynamicCols = new ArrayList<Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            JCol col = cols.get(i);
            if (col.getWidth() == null) {
                dynamicCols.add(i);
                continue;
            }
            result[i] = col.getWidth();
            remainingWidth -= col.getWidth().intValue();
        }
        if (!dynamicCols.isEmpty()) {
            int leftoverWidth = remainingWidth % dynamicCols.size();
            int colWidth = remainingWidth / dynamicCols.size();
            for (Integer dynamicIndex : dynamicCols) {
                result[dynamicIndex.intValue()] = colWidth;
            }
            if (leftoverWidth > 0) {
                result[result.length - 1] = result[result.length - 1] + leftoverWidth;
            }
        }
        if ((rowWidth = Arrays.stream(result).sum()) != tableWidth) {
            throw new IllegalArgumentException("Row width does not match table width. Expected " + tableWidth + " but got " + rowWidth);
        }
        return result;
    }

    public static String renderBottomBorder(int[] colsWidth, Chars theme) {
        StringBuilder builder = new StringBuilder();
        for (int aColsWidth : colsWidth) {
            if (builder.length() == 0) {
                JTable.safeAppend(builder, theme.bottomLeft);
            } else {
                JTable.safeAppend(builder, theme.bottomIntersect);
            }
            JTable.safeAppend(builder, theme.horizontal, aColsWidth);
        }
        JTable.safeAppend(builder, theme.bottomRight);
        return builder.toString();
    }

    public static String renderTopBorder(int[] colsWidth, int[] previousColsWidth, int tableWidth, Chars theme) {
        StringBuilder builder = new StringBuilder();
        for (int aColsWidth : colsWidth) {
            if (builder.length() == 0) {
                JTable.safeAppend(builder, theme.topLeft);
            } else {
                JTable.safeAppend(builder, theme.topIntersect);
            }
            JTable.safeAppend(builder, theme.horizontal, aColsWidth);
        }
        JTable.safeAppend(builder, theme.topRight);
        if (previousColsWidth != null) {
            JTable.safeInsert(builder, 0, theme.leftIntersect);
            int prevIdx = 1;
            for (int prevColWidth : previousColsWidth) {
                if ((prevIdx += prevColWidth) <= builder.length()) {
                    if (builder.charAt(prevIdx) == theme.topIntersect) {
                        JTable.safeInsert(builder, prevIdx, theme.intersect);
                    } else if (builder.charAt(prevIdx) == theme.horizontal) {
                        JTable.safeInsert(builder, prevIdx, theme.bottomIntersect);
                    } else if (builder.charAt(prevIdx) == theme.topRight) {
                        JTable.safeInsert(builder, prevIdx, theme.rightIntersect);
                    } else {
                        throw new IllegalArgumentException("Do not know how to replace '" + builder.charAt(prevIdx) + "'");
                    }
                }
                ++prevIdx;
            }
        }
        return builder.toString();
    }

    private static void safeInsert(StringBuilder builder, int idx, char character) {
        if (character != '\u0000') {
            builder.setCharAt(idx, character);
        }
    }

    private static void safeAppend(StringBuilder builder, char character, int repeat) {
        if (character != '\u0000') {
            builder.append(StringUtils.repeat((char)character, (int)repeat));
        }
    }

    private static void safeAppend(StringBuilder builder, char character) {
        JTable.safeAppend(builder, character, 1);
    }

    public List<JRow> getRows() {
        return this.rows;
    }

    public int getWidth() {
        return this.width;
    }

    public JTheme getTheme() {
        return this.theme;
    }

    public ContentParser getContentParser() {
        return this.contentParser;
    }

    private static class RenderedCol {
        private final JCol col;
        private final int widthToUse;
        private final List<String> renderedCol;

        public int getHeight() {
            return this.renderedCol.size();
        }

        @ConstructorProperties(value={"col", "widthToUse", "renderedCol"})
        public RenderedCol(JCol col, int widthToUse, List<String> renderedCol) {
            this.col = col;
            this.widthToUse = widthToUse;
            this.renderedCol = renderedCol;
        }

        public JCol getCol() {
            return this.col;
        }

        public int getWidthToUse() {
            return this.widthToUse;
        }

        public List<String> getRenderedCol() {
            return this.renderedCol;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenderedCol)) {
                return false;
            }
            RenderedCol other = (RenderedCol)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JCol this$col = this.getCol();
            JCol other$col = other.getCol();
            if (this$col == null ? other$col != null : !this$col.equals(other$col)) {
                return false;
            }
            if (this.getWidthToUse() != other.getWidthToUse()) {
                return false;
            }
            List<String> this$renderedCol = this.getRenderedCol();
            List<String> other$renderedCol = other.getRenderedCol();
            return !(this$renderedCol == null ? other$renderedCol != null : !((Object)this$renderedCol).equals(other$renderedCol));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenderedCol;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JCol $col = this.getCol();
            result = result * 59 + ($col == null ? 43 : $col.hashCode());
            result = result * 59 + this.getWidthToUse();
            List<String> $renderedCol = this.getRenderedCol();
            result = result * 59 + ($renderedCol == null ? 43 : ((Object)$renderedCol).hashCode());
            return result;
        }

        public String toString() {
            return "JTable.RenderedCol(col=" + this.getCol() + ", widthToUse=" + this.getWidthToUse() + ", renderedCol=" + this.getRenderedCol() + ")";
        }
    }
}

