/*
 * Decompiled with CFR 0.152.
 */
package net.je2sh.asciitable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.je2sh.asciitable.JRow;
import net.je2sh.asciitable.style.JPadding;
import net.je2sh.asciitable.style.JTheme;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class JCol {
    private final JRow row;
    private Integer width;
    private Object content;
    private JPadding padding;

    public JCol(JRow row) {
        this.row = row;
    }

    public JCol content(Object content) {
        this.content = content;
        return this;
    }

    public JCol width(int width) {
        this.width = width;
        return this;
    }

    public JCol padding(JPadding padding) {
        this.padding = padding;
        return this;
    }

    public JPadding getPadding() {
        return Optional.ofNullable(this.padding).orElse(this.row.getPadding());
    }

    public JRow done() {
        return this.row;
    }

    public List<String> render(JTheme theme, int widthToUse) {
        return this.render(theme, widthToUse, null);
    }

    public List<String> render(JTheme theme, int widthToUse, Integer heightToUse) {
        ArrayList<String> colResult = new ArrayList<String>();
        if (this.getPadding().getTop() > 0) {
            String topPadding = (theme.vertical != '\u0000' ? Character.valueOf(theme.vertical) : "") + StringUtils.repeat((char)this.getPadding().getTopCharacter().charValue(), (int)widthToUse);
            for (int i = 0; i < this.getPadding().getTop(); ++i) {
                colResult.add(topPadding);
            }
        }
        for (String contentLine : this.wrapLines(this.content.toString(), widthToUse)) {
            colResult.add((theme.vertical != '\u0000' ? Character.valueOf(theme.vertical) : "") + contentLine);
        }
        if (this.getPadding().getBottom() > 0 || heightToUse != null && heightToUse > 0) {
            int bottomHeight = Math.max(this.getPadding().getBottom(), Optional.ofNullable(heightToUse).orElse(0));
            String bottomPadding = (theme.vertical != '\u0000' ? Character.valueOf(theme.vertical) : "") + StringUtils.repeat((char)this.getPadding().getBottomCharacter().charValue(), (int)widthToUse);
            for (int i = 0; i < bottomHeight; ++i) {
                colResult.add(bottomPadding);
            }
        }
        return colResult;
    }

    private List<String> wrapLines(String rawContent, int widthToUse) {
        ArrayList<String> result = new ArrayList<String>();
        int rawContentLength = this.row.getTable().getContentParser().getLength(rawContent);
        for (String explicitLine : WordUtils.wrap((String)rawContent, (int)(widthToUse - this.getPadding().getLeft() - this.getPadding().getRight() + (rawContent.length() - rawContentLength)), (String)"\n", (boolean)true).split("\n")) {
            String contentStr = StringUtils.repeat((char)this.getPadding().getLeftCharacter().charValue(), (int)this.getPadding().getLeft()) + explicitLine + StringUtils.repeat((char)this.getPadding().getRightCharacter().charValue(), (int)this.getPadding().getRight());
            int contentLength = this.row.getTable().getContentParser().getLength(contentStr);
            StringBuilder extraPadding = new StringBuilder();
            if (this.getPadding().getRight() > 0) {
                extraPadding.append(StringUtils.repeat((char)this.getPadding().getRightCharacter().charValue(), (int)(widthToUse - contentLength)));
            } else {
                extraPadding.append(StringUtils.repeat((char)' ', (int)(widthToUse - contentLength)));
            }
            result.add(contentStr + extraPadding.toString());
        }
        return result;
    }

    public JRow getRow() {
        return this.row;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Object getContent() {
        return this.content;
    }
}

