/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.jawr.web.bundle.processor.BundleProcessor;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;

public class BundleTask
extends Task {
    private static final String DEFAULT_SERVLET_API_VERSION = "2.3";
    private static final String SERVLET_NAME_SEPARATOR = ",";
    private String rootPath;
    private String tempDirPath;
    private String destDirPath;
    private String servletsToInitialize;
    private String springConfigFiles;
    private boolean generateCDNFiles = true;
    private boolean keepUrlMapping = false;
    private String servletAPIversion = "2.3";

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setTempDirPath(String tempDirPath) {
        this.tempDirPath = tempDirPath;
    }

    public void setDestDirPath(String destDirPath) {
        this.destDirPath = destDirPath;
    }

    public void setServletsToInitialize(String servletsToInitialize) {
        this.servletsToInitialize = servletsToInitialize;
    }

    public void setSpringConfigFiles(String springConfigFiles) {
        this.springConfigFiles = springConfigFiles;
    }

    public void setGenerateCDNFiles(boolean generateCDNFiles) {
        this.generateCDNFiles = generateCDNFiles;
    }

    public void setKeepUrlMapping(boolean keepUrlMapping) {
        this.keepUrlMapping = keepUrlMapping;
    }

    public void setServletAPIversion(String servletAPIversion) {
        this.servletAPIversion = servletAPIversion;
    }

    public void execute() {
        try {
            this.createBundles();
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            if (ex instanceof ServletException) {
                logger.log(Level.SEVERE, null, ((ServletException)ex).getRootCause());
            }
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void createBundles() throws Exception {
        File tempDir = new File(this.tempDirPath);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        } else {
            this.cleanDirectory(tempDir);
        }
        File destDir = new File(this.destDirPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            this.cleanDirectory(destDir);
        }
        ArrayList<String> servlets = new ArrayList<String>();
        if (this.servletsToInitialize != null) {
            String[] servletNames = this.servletsToInitialize.split(SERVLET_NAME_SEPARATOR);
            for (int i = 0; i < servletNames.length; ++i) {
                servlets.add(servletNames[i].trim());
            }
        }
        BundleProcessor bundleProcessor = new BundleProcessor();
        bundleProcessor.process(this.rootPath, this.tempDirPath, this.destDirPath, this.springConfigFiles, servlets, this.generateCDNFiles, this.keepUrlMapping, this.servletAPIversion);
    }

    public void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        Delete deleteTask = new Delete();
        deleteTask.setProject(this.getProject());
        deleteTask.setDir(directory);
        deleteTask.execute();
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

