/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.http.test.server.servlet;

import net.javacrumbs.smock.common.server.CommonSmockServer;
import net.javacrumbs.smock.http.server.servlet.CommonServletBasedMockWebServiceClient;
import net.javacrumbs.smock.http.test.server.servlet.test.TstWebService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.test.server.RequestCreator;
import org.springframework.ws.test.server.ResponseMatcher;

public abstract class AbstractServletBasedMockWebServiceClientTest {
    protected abstract CommonServletBasedMockWebServiceClient createMockClient(ApplicationContext var1, ClientInterceptor[] var2);

    @Test
    public void testNormal() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("servlet.xml");
        CommonServletBasedMockWebServiceClient client = this.createMockClient((ApplicationContext)context, null);
        client.sendRequestTo("/TestWebService", (RequestCreator)CommonSmockServer.withMessage((String)"request.xml")).andExpect((ResponseMatcher)CommonSmockServer.message((String)"response.xml"));
        Assert.assertNotNull((Object)TstWebService.getValue());
    }

    @Test
    public void testInterceptor() {
        ClientInterceptor interceptor = (ClientInterceptor)EasyMock.createMock(ClientInterceptor.class);
        EasyMock.expect((Object)interceptor.handleRequest((MessageContext)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)interceptor.handleResponse((MessageContext)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{interceptor});
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("servlet.xml");
        CommonServletBasedMockWebServiceClient client = this.createMockClient((ApplicationContext)context, new ClientInterceptor[]{interceptor});
        client.sendRequestTo("/TestWebService", (RequestCreator)CommonSmockServer.withMessage((String)"request.xml")).andExpect((ResponseMatcher)CommonSmockServer.message((String)"response.xml"));
        Assert.assertNotNull((Object)TstWebService.getValue());
        EasyMock.verify((Object[])new Object[]{interceptor});
    }
}

