/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.mocksocket.connection.sequential;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.mocksocket.MockSocketException;
import net.javacrumbs.mocksocket.connection.AbstractMockConnection;
import net.javacrumbs.mocksocket.connection.MockConnection;
import net.javacrumbs.mocksocket.connection.data.SocketData;
import net.javacrumbs.mocksocket.connection.sequential.SequentialMockRecorder;

public class SequentialMockConnection
extends AbstractMockConnection
implements MockConnection,
SequentialMockRecorder {
    private final List<SocketData> responseData = new ArrayList<SocketData>();

    public SequentialMockRecorder andReturn(SocketData data) {
        this.responseData.add(data);
        return this;
    }

    public InputStream createInputStream() throws IOException {
        if (this.responseData.size() > this.actualConnection) {
            return new ByteArrayInputStream(this.responseData.get(this.actualConnection).getBytes());
        }
        throw new MockSocketException("No more connections expected. Requests recorded so far are: " + this.requestData());
    }
}

