/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.mocksocket.connection.matcher;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.mocksocket.MockSocketException;
import net.javacrumbs.mocksocket.connection.AbstractMockConnection;
import net.javacrumbs.mocksocket.connection.MockConnection;
import net.javacrumbs.mocksocket.connection.data.RequestSocketData;
import net.javacrumbs.mocksocket.connection.data.SocketData;
import net.javacrumbs.mocksocket.connection.matcher.MatcherBasedMockRecorder;
import net.javacrumbs.mocksocket.connection.matcher.MatcherBasedMockResultRecorder;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherBasedMockConnection
extends AbstractMockConnection
implements MockConnection,
MatcherBasedMockResultRecorder,
MatcherBasedMockRecorder {
    private final List<MatcherWithData> matchers = new ArrayList<MatcherWithData>();

    @Override
    public InputStream createInputStream() throws IOException {
        return new RedirectingInputStream(this.getRequestSocketData());
    }

    @Override
    public MatcherBasedMockRecorder thenReturn(SocketData data) {
        this.matchers.get(this.matchers.size() - 1).addData(data);
        return this;
    }

    @Override
    public MatcherBasedMockResultRecorder andWhenRequest(Matcher<RequestSocketData> matcher) {
        this.matchers.add(new MatcherWithData(matcher));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MatcherWithData {
        private final Matcher<RequestSocketData> matcher;
        private final List<SocketData> responseData = new ArrayList<SocketData>();
        private int actualResponse = 0;

        public MatcherWithData(Matcher<RequestSocketData> matcher) {
            this.matcher = matcher;
        }

        public InputStream getResponse() {
            if (this.responseData.size() > this.actualResponse) {
                return new ByteArrayInputStream(this.responseData.get(this.actualResponse++).getBytes());
            }
            throw new MockSocketException("No more connections expected for request matching matcher: " + this.matcher + ". Requests recorded so far are: " + MatcherBasedMockConnection.this.requestData());
        }

        public void addData(SocketData data) {
            this.responseData.add(data);
        }

        public Matcher<RequestSocketData> getMatcher() {
            return this.matcher;
        }
    }

    class RedirectingInputStream
    extends InputStream {
        private final RequestSocketData requestSocketData;
        private InputStream wrappedInputStream;

        public RedirectingInputStream(RequestSocketData requestSocketData) {
            this.requestSocketData = requestSocketData;
        }

        public int read() throws IOException {
            if (this.wrappedInputStream == null) {
                this.wrappedInputStream = this.findInputStream();
            }
            return this.wrappedInputStream.read();
        }

        private InputStream findInputStream() throws IOException, MockSocketException {
            for (MatcherWithData matcher : MatcherBasedMockConnection.this.matchers) {
                if (!matcher.getMatcher().matches((Object)this.requestSocketData)) continue;
                return matcher.getResponse();
            }
            throw new MockSocketException("No matcher matches request " + this.requestSocketData + ". Do not know which response to return.");
        }
    }
}

