/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.mocksocket.connection;

import java.io.IOException;
import java.net.Socket;
import net.javacrumbs.mocksocket.connection.Connection;
import net.javacrumbs.mocksocket.connection.ConnectionFactory;
import net.javacrumbs.mocksocket.connection.MockConnection;
import net.javacrumbs.mocksocket.connection.UniversalMockConnection;
import net.javacrumbs.mocksocket.connection.UniversalMockRecorder;
import net.javacrumbs.mocksocket.socket.MockSocketImplFactory;

public class StaticConnectionFactory
implements ConnectionFactory {
    private static UniversalMockConnection expectedConnection;

    static void bootstrap() {
        try {
            Socket.setSocketImplFactory(new MockSocketImplFactory(new StaticConnectionFactory()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not bootstrap the connection factory", e);
        }
    }

    public synchronized Connection createConnection(String address) {
        UniversalMockConnection connection = expectedConnection;
        if (connection == null) {
            throw new IllegalStateException("Connection not expected. You have to call expectCall() first.");
        }
        connection.onCreate(address);
        return connection;
    }

    public static synchronized UniversalMockRecorder expectCall() {
        if (StaticConnectionFactory.getConnection() == null) {
            UniversalMockConnection mockConnection = new UniversalMockConnection();
            StaticConnectionFactory.setExpectedConnection(mockConnection);
            return mockConnection;
        }
        throw new IllegalArgumentException("Can not call expectCall twice. You have to call reset before each test. If you need simulate multiple requests, please call andReturn several times.");
    }

    public static synchronized void reset() {
        expectedConnection = null;
    }

    protected static void setExpectedConnection(UniversalMockConnection mockConnection) {
        expectedConnection = mockConnection;
    }

    public static synchronized MockConnection getConnection() {
        return expectedConnection;
    }

    static {
        StaticConnectionFactory.bootstrap();
    }
}

