/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.mocksocket.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.mocksocket.connection.MockConnection;
import net.javacrumbs.mocksocket.connection.data.OutputSocketData;
import net.javacrumbs.mocksocket.connection.data.RequestSocketData;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMockConnection
implements MockConnection {
    private final List<OutputSocketData> requestData = new ArrayList<OutputSocketData>();
    protected int actualConnection = -1;
    private InputStream inputStream;

    public void onCreate(String address) {
        ++this.actualConnection;
        this.requestData.add(this.createRequestSocket(address));
        this.inputStream = null;
    }

    protected OutputSocketData createRequestSocket(String address) {
        return new OutputSocketData(address);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getRequestSocketData().getOutputStream();
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.createInputStream();
        }
        return this.inputStream;
    }

    protected abstract InputStream createInputStream() throws IOException;

    protected OutputSocketData getRequestSocketData() {
        return this.requestData.get(this.actualConnection);
    }

    @Override
    public List<RequestSocketData> requestData() {
        return new ArrayList<RequestSocketData>(this.requestData);
    }

    protected int getActualConnection() {
        return this.actualConnection;
    }

    protected void setActualConnection(int actualConnection) {
        this.actualConnection = actualConnection;
    }

    public boolean containsRequestThat(Matcher<RequestSocketData> matcher) {
        for (OutputSocketData data : this.requestData) {
            if (!matcher.matches((Object)data)) continue;
            return true;
        }
        return false;
    }
}

