/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;

public class JsonFluentAssert {
    final InternalMatcher internalMatcher;

    private JsonFluentAssert(InternalMatcher internalMatcher) {
        this.internalMatcher = internalMatcher;
    }

    private JsonFluentAssert(Object actual, Path path, String description, Configuration configuration) {
        this.internalMatcher = new InternalMatcher(actual, path, description, configuration);
    }

    private JsonFluentAssert(Object actual, String pathPrefix) {
        this(actual, Path.create((String)"", (String)pathPrefix), "", Configuration.empty());
    }

    public static ConfigurableJsonFluentAssert assertThatJson(Object json) {
        return new ConfigurableJsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)"actual"), JsonUtils.getPathPrefix((Object)json));
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        this.internalMatcher.isEqualTo(expected);
        return this;
    }

    public JsonFluentAssert isStringEqualTo(String expected) {
        this.internalMatcher.isStringEqualTo(expected);
        return this;
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        this.internalMatcher.isNotEqualTo(expected);
        return this;
    }

    public JsonFluentAssert node(String newPath) {
        return new JsonFluentAssert(this.internalMatcher.node(newPath));
    }

    public JsonFluentAssert isAbsent() {
        this.internalMatcher.isAbsent();
        return this;
    }

    public JsonFluentAssert isPresent() {
        this.internalMatcher.isPresent();
        return this;
    }

    public ArrayAssert isArray() {
        return new ArrayAssert(this.internalMatcher.isArray());
    }

    public void isObject() {
        this.internalMatcher.isObject();
    }

    public void isString() {
        this.internalMatcher.isString();
    }

    public JsonFluentAssert matches(Matcher<?> matcher) {
        this.internalMatcher.matches(matcher);
        return this;
    }

    public static class ConfigurableJsonFluentAssert
    extends JsonFluentAssert {
        private ConfigurableJsonFluentAssert(InternalMatcher internalMatcher) {
            super(internalMatcher);
        }

        private ConfigurableJsonFluentAssert(Object actual, String pathPrefix) {
            super(actual, pathPrefix);
        }

        @Override
        public ConfigurableJsonFluentAssert node(String newPath) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.node(newPath));
        }

        public ConfigurableJsonFluentAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.whenIgnoringPaths(pathsToBeIgnored));
        }

        public ConfigurableJsonFluentAssert as(String description) {
            return this.describedAs(description);
        }

        public ConfigurableJsonFluentAssert describedAs(String description) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.describedAs(description));
        }

        public ConfigurableJsonFluentAssert ignoring(String ignorePlaceholder) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withIgnorePlaceholder(ignorePlaceholder));
        }

        public ConfigurableJsonFluentAssert withTolerance(double tolerance) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withTolerance(tolerance));
        }

        public ConfigurableJsonFluentAssert withTolerance(BigDecimal tolerance) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withTolerance(tolerance));
        }

        public ConfigurableJsonFluentAssert withMatcher(String matcherName, Matcher<?> matcher) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withMatcher(matcherName, matcher));
        }

        public ConfigurableJsonFluentAssert withDifferenceListener(DifferenceListener differenceListener) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withDifferenceListener(differenceListener));
        }

        public ConfigurableJsonFluentAssert when(Option firstOption, Option ... otherOptions) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.withOptions(firstOption, otherOptions));
        }

        public final ConfigurableJsonFluentAssert when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
            return new ConfigurableJsonFluentAssert(this.internalMatcher.when(object, actions));
        }
    }

    public static class ArrayAssert {
        private final InternalMatcher.ArrayMatcher arrayMatcher;

        ArrayAssert(InternalMatcher.ArrayMatcher arrayMatcher) {
            this.arrayMatcher = arrayMatcher;
        }

        public ArrayAssert ofLength(int expectedLength) {
            this.arrayMatcher.ofLength(expectedLength);
            return this;
        }

        public ArrayAssert thatContains(Object expected) {
            this.arrayMatcher.thatContains(expected);
            return this;
        }

        public ArrayAssert isEmpty() {
            this.arrayMatcher.isEmpty();
            return this;
        }

        public ArrayAssert isNotEmpty() {
            this.arrayMatcher.isNotEmpty();
            return this;
        }
    }
}

