/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.truecommons.io.PowerBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ReadOnlyChannelITSuite {
    private static final Logger logger = Logger.getLogger(ReadOnlyChannelITSuite.class.getName());
    protected static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    protected static final byte[] DATA = new byte[1024];
    private Path temp;
    private SeekableByteChannel rchannel;
    private SeekableByteChannel tchannel;
    private byte[] data;

    @Before
    public void setUp() throws IOException {
        this.temp = Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]);
        try {
            Files.write(this.temp, DATA, new OpenOption[0]);
            assert ((long)DATA.length == Files.size(this.temp));
            this.rchannel = Files.newByteChannel(this.temp, new OpenOption[0]);
            this.tchannel = this.newChannel(this.temp);
        }
        catch (Throwable ex) {
            try {
                Files.delete(this.temp);
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        this.data = (byte[])DATA.clone();
    }

    protected abstract SeekableByteChannel newChannel(Path var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        try {
            try {
                try {
                    SeekableByteChannel tsbc = this.tchannel;
                    this.tchannel = null;
                    if (tsbc != null) {
                        tsbc.close();
                    }
                }
                finally {
                    SeekableByteChannel rsbc = this.rchannel;
                    this.rchannel = null;
                    if (rsbc != null) {
                        rsbc.close();
                    }
                }
            }
            finally {
                Files.deleteIfExists(this.temp);
            }
        }
        catch (IOException ex) {
            logger.log(Level.FINEST, "Failed to clean up test file (this may be just an aftermath):", ex);
        }
    }

    @Test
    public void testWrite() throws IOException {
        this.assertWrite(this.rchannel);
        this.assertWrite(this.tchannel);
    }

    private void assertWrite(SeekableByteChannel channel) throws IOException {
        try {
            channel.write(ByteBuffer.allocate(1));
            Assert.fail();
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            // empty catch block
        }
    }

    @Test
    public void testTruncate() throws IOException {
        this.assertTruncate(this.rchannel);
        this.assertTruncate(this.tchannel);
    }

    private void assertTruncate(SeekableByteChannel channel) throws IOException {
        try {
            channel.truncate(0L);
            Assert.fail();
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            // empty catch block
        }
    }

    @Test
    public void testClose() throws IOException {
        ReadOnlyChannelITSuite.close(this.rchannel);
        ReadOnlyChannelITSuite.close(this.tchannel);
    }

    private static void close(SeekableByteChannel channel) throws IOException {
        channel.close();
        try {
            channel.size();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            channel.position();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            channel.position(0L);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Assert.assertEquals((long)0L, (long)channel.read(ByteBuffer.allocate(0)));
        }
        catch (IOException mayHappen) {
            // empty catch block
        }
        try {
            channel.read(ByteBuffer.allocate(1));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        channel.close();
    }

    @Test
    public void testLength() throws Exception {
        Assert.assertEquals((long)this.data.length, (long)this.rchannel.size());
        Assert.assertEquals((long)this.data.length, (long)this.tchannel.size());
    }

    @Test
    public void testForwardReadBytes() throws IOException {
        this.assertForwardReadBytes(this.rchannel);
        this.assertForwardReadBytes(this.tchannel);
    }

    private void assertForwardReadBytes(SeekableByteChannel channel) throws IOException {
        long size = channel.size();
        int off = 0;
        while ((long)off < size) {
            Assert.assertEquals((long)(this.data[off] & 0xFF), (long)ReadOnlyChannelITSuite.readByte(channel));
            ++off;
        }
        Assert.assertEquals((long)-1L, (long)ReadOnlyChannelITSuite.readByte(channel));
    }

    private static int readByte(ReadableByteChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        return 1 != channel.read(buf) ? -1 : buf.get(0) & 0xFF;
    }

    @Test
    public void testRandomReadBytes() throws IOException {
        this.assertRandomReadBytes(this.rchannel);
        this.assertRandomReadBytes(this.tchannel);
    }

    private void assertRandomReadBytes(SeekableByteChannel channel) throws IOException {
        int size;
        Assert.assertEquals((long)0L, (long)channel.position());
        this.assertReadAtPosition(channel, 0);
        int i = size = (int)channel.size();
        while (--i >= 0) {
            int tooSmall = rnd.nextInt() | Integer.MIN_VALUE;
            try {
                this.assertReadAtPosition(channel, tooSmall);
                Assert.fail();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            int tooLarge = Math.max(size, rnd.nextInt() & Integer.MAX_VALUE);
            this.assertReadAtPosition(channel, tooLarge);
            int justRight = rnd.nextInt(size);
            this.assertReadAtPosition(channel, justRight);
        }
    }

    private void assertReadAtPosition(SeekableByteChannel channel, int pos) throws IOException {
        channel.position(pos);
        Assert.assertEquals((long)pos, (long)channel.position());
        if ((long)pos < channel.size()) {
            Assert.assertEquals((long)(this.data[pos] & 0xFF), (long)ReadOnlyChannelITSuite.readByte(channel));
            Assert.assertEquals((long)(pos + 1), (long)channel.position());
        } else {
            Assert.assertEquals((long)-1L, (long)ReadOnlyChannelITSuite.readByte(channel));
            Assert.assertEquals((long)pos, (long)channel.position());
        }
    }

    @Test
    public void testBackwardReadBytes() throws IOException {
        this.assertBackwardReadBytes(this.rchannel);
        this.assertBackwardReadBytes(this.tchannel);
    }

    private void assertBackwardReadBytes(SeekableByteChannel channel) throws IOException {
        int size;
        int pos = size = (int)channel.size();
        while (--pos >= 0) {
            this.assertReadAtPosition(channel, pos);
        }
    }

    @Test
    public void testForwardReadChunks() throws IOException {
        byte[] buf;
        int read;
        int size = (int)this.rchannel.size();
        int pos = 0;
        while (0 <= (read = this.rchannel.read(ByteBuffer.wrap(buf = new byte[rnd.nextInt(size / 100)])))) {
            if (0 < buf.length) {
                Assert.assertTrue((0 < read ? 1 : 0) != 0);
                Assert.assertEquals((Object)ByteBuffer.wrap(this.data, pos, read), (Object)ByteBuffer.wrap(buf, 0, read));
                Arrays.fill(buf, (byte)0);
                PowerBuffer.wrap((byte[])buf, (int)0, (int)read).load((ReadableByteChannel)this.tchannel);
                Assert.assertEquals((Object)ByteBuffer.wrap(this.data, pos, read), (Object)ByteBuffer.wrap(buf, 0, read));
            } else {
                Assert.assertEquals((long)0L, (long)read);
                Assert.assertEquals((long)0L, (long)this.tchannel.read(ByteBuffer.wrap(buf)));
            }
            pos += read;
        }
        Assert.assertEquals((long)pos, (long)size);
        Assert.assertEquals((long)-1L, (long)read);
        Assert.assertEquals((long)-1L, (long)ReadOnlyChannelITSuite.readByte(this.tchannel));
        Assert.assertEquals((long)0L, (long)this.rchannel.read(ByteBuffer.allocate(0)));
        Assert.assertEquals((long)0L, (long)this.tchannel.read(ByteBuffer.allocate(0)));
    }

    @Test
    public void testRandomReadChunks() throws IOException {
        int size = (int)this.rchannel.size();
        int i = 100;
        while (--i >= 0) {
            int pos = rnd.nextInt(size);
            this.assertReadAtPosition(this.rchannel, pos);
            this.assertReadAtPosition(this.tchannel, pos);
            ++pos;
            byte[] buf = new byte[rnd.nextInt(size / 100)];
            int read = this.rchannel.read(ByteBuffer.wrap(buf));
            if (read < 0) continue;
            if (buf.length > 0) {
                Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)ByteBuffer.wrap(this.data, pos, read), (Object)ByteBuffer.wrap(buf, 0, read));
                Arrays.fill(buf, (byte)0);
                PowerBuffer.wrap((byte[])buf, (int)0, (int)read).load((ReadableByteChannel)this.tchannel);
                Assert.assertEquals((Object)ByteBuffer.wrap(this.data, pos, read), (Object)ByteBuffer.wrap(buf, 0, read));
                continue;
            }
            Assert.assertEquals((long)0L, (long)read);
            Assert.assertEquals((long)0L, (long)this.tchannel.read(ByteBuffer.wrap(buf)));
        }
    }

    static {
        rnd.nextBytes(DATA);
    }
}

