/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.ReadOnlyChannelITSuite;
import org.junit.After;
import org.junit.Before;

public class IntervalReadOnlyChannelIT
extends ReadOnlyChannelITSuite {
    private static final Logger logger = Logger.getLogger(IntervalReadOnlyChannelIT.class.getName());
    private Path temp2;

    @Override
    @Before
    public void setUp() throws IOException {
        this.temp2 = Files.createTempFile("tzp", null, new FileAttribute[0]);
        try {
            try (OutputStream out = Files.newOutputStream(this.temp2, new OpenOption[0]);){
                out.write(DATA);
                out.write(DATA);
                out.write(DATA);
            }
            assert ((long)(3 * DATA.length) == Files.size(this.temp2));
        }
        catch (Throwable ex) {
            try {
                Files.delete(this.temp2);
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        super.setUp();
    }

    @Override
    protected SeekableByteChannel newChannel(Path path) throws IOException {
        SeekableByteChannel sbc = Files.newByteChannel(this.temp2, new OpenOption[0]);
        sbc.position(DATA.length);
        return new IntervalReadOnlyChannel(sbc, (long)DATA.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() {
        try {
            super.tearDown();
        }
        finally {
            try {
                Files.deleteIfExists(this.temp2);
            }
            catch (IOException ex) {
                logger.log(Level.FINEST, "Failed to clean up test file (this may be just an aftermath):", ex);
            }
        }
    }
}

