/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import net.java.quickcheck.srcgenerator.Assertion;
import net.java.quickcheck.srcgenerator.Method;
import net.java.quickcheck.srcgenerator.Traversal;

class ClassInfo {
    private static final Set<Modifier> METHOD_MODIFIERS = EnumSet.of(Modifier.STATIC, Modifier.PUBLIC);
    final CharSequence className;
    final CharSequence packageName;
    final Set<Method> methods = new HashSet<Method>();

    ClassInfo(ProcessingEnvironment env, Element annotatedElement) {
        TypeElement classDeclaration = this.classDeclaration(annotatedElement);
        this.packageName = this.packageName(env, classDeclaration);
        this.className = classDeclaration.getSimpleName();
        for (ExecutableElement method : this.findMethods(classDeclaration)) {
            this.methods.add(new Method(env.getMessager(), method));
        }
    }

    ClassInfo(Name packageName, Name className, Method ... methods) {
        this.packageName = packageName;
        this.className = className;
        this.methods.addAll(Arrays.asList(methods));
    }

    private Name packageName(ProcessingEnvironment env, TypeElement classDeclaration) {
        return env.getElementUtils().getPackageOf(classDeclaration).getQualifiedName();
    }

    private List<ExecutableElement> findMethods(Element classDeclaration) {
        ArrayList<ExecutableElement> es = new ArrayList<ExecutableElement>();
        for (ExecutableElement executable : ElementFilter.methodsIn(classDeclaration.getEnclosedElements())) {
            if (!executable.getModifiers().containsAll(METHOD_MODIFIERS)) continue;
            es.add(executable);
        }
        return es;
    }

    private TypeElement classDeclaration(Element annotatedElements) {
        TypeElement type = Traversal.toTypeElement(annotatedElements);
        Assertion.assertTrue(type.getKind() == ElementKind.CLASS, "Its only allowed to annotate classes.", new Object[0]);
        return type;
    }

    public boolean equals(Object obj) {
        ClassInfo info = (ClassInfo)obj;
        return info.className.equals(this.className) && info.packageName.equals(this.packageName) && ((Object)info.methods).equals(this.methods);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return String.format("ClassInfo[className=%s, packageName=%s, methods=%s]", this.className, this.packageName, this.methods);
    }
}

