/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private static final Log log = LogFactory.getLog(Scanner.class);
    private String resourceName;
    private ClassLoader classLoader;
    private ArrayList<String> excludePackages = new ArrayList();
    private ArrayList<String> includePackages = new ArrayList();
    private boolean scanDirs = true;

    public Scanner() {
        this("to.properties", Thread.currentThread().getContextClassLoader());
    }

    public Scanner(String resourceName, ClassLoader classLoader) {
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    public Scanner(boolean scanDirs, ArrayList<String> includePackages, ArrayList<String> excludePackages) {
        this("to.properties", Thread.currentThread().getContextClassLoader());
        this.scanDirs = scanDirs;
        this.includePackages = includePackages;
        this.excludePackages = excludePackages;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public Set<Class<?>> getClasses() {
        File file;
        Enumeration<URL> urls;
        ArrayList<String> dirs;
        HashSet result;
        block16: {
            result = new HashSet();
            dirs = new ArrayList<String>();
            try {
                urls = this.classLoader.getResources(this.resourceName);
            }
            catch (IOException ioe) {
                log.warn((Object)("could not read: " + this.resourceName), (Throwable)ioe);
                return result;
            }
            try {
                if (!this.scanDirs) break block16;
                try {
                    Enumeration<URL> urls2 = this.classLoader.getResources(".");
                    while (urls2.hasMoreElements()) {
                        String urlPath = urls2.nextElement().getFile();
                        if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                            urlPath = urlPath.substring(5);
                        }
                        if (urlPath.indexOf(33) > 0) {
                            urlPath = urlPath.substring(0, urlPath.indexOf(33));
                        }
                        log.debug((Object)("scanning: " + urlPath));
                        file = new File(urlPath);
                        if (!file.isDirectory()) continue;
                        dirs.add(file.toString());
                    }
                }
                catch (IOException ioe) {
                    log.warn((Object)"could not read entries", (Throwable)ioe);
                }
            }
            catch (AccessControlException e) {
                // empty catch block
            }
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                urlPath = urlPath.indexOf(33) > 0 ? urlPath.substring(0, urlPath.indexOf(33)) : new File(urlPath).getParent();
                log.debug((Object)("scanning: " + urlPath));
                File file2 = new File(urlPath);
                if (file2.isDirectory()) {
                    if (dirs.contains(urlPath)) {
                        dirs.remove(urlPath);
                    }
                    this.handleDirectory(result, file2, null);
                    continue;
                }
                this.handleArchive(result, file2);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", (Throwable)ioe);
            }
        }
        for (String urlPath : dirs) {
            file = new File(urlPath + "/");
            this.handleDirectory(result, file, null);
        }
        return result;
    }

    private void handleArchive(Set<Class<?>> result, File file) throws ZipException, IOException {
        log.debug((Object)("archive: " + file));
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            log.debug((Object)("found: " + name));
            this.handleItem(result, name);
        }
    }

    private void handleDirectory(Set<Class<?>> result, File file, String path) {
        log.debug((Object)("directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(result, child, newPath);
                continue;
            }
            this.handleItem(result, newPath);
        }
    }

    private void handleItem(Set<Class<?>> result, String name) {
        if (name.endsWith(".class")) {
            boolean proceed;
            if (!this.includePackages.isEmpty()) {
                proceed = false;
                for (String regexp : this.includePackages) {
                    if (!name.matches(regexp)) continue;
                    proceed = true;
                }
                if (!proceed) {
                    return;
                }
            }
            if (!this.excludePackages.isEmpty()) {
                proceed = true;
                for (String regexp : this.excludePackages) {
                    if (!name.matches(regexp)) continue;
                    proceed = false;
                }
                if (!proceed) {
                    return;
                }
            }
            String classname = Scanner.filenameToClassname(name);
            try {
                result.add(this.classLoader.loadClass(classname));
            }
            catch (ClassNotFoundException cnfe) {
                log.debug((Object)("could not load class: " + classname), (Throwable)cnfe);
            }
            catch (NoClassDefFoundError cnfe) {
                log.debug((Object)("could not load class: " + classname), (Throwable)cnfe);
            }
        }
    }
}

