/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.java.dev.springannotation.annotation.Alias;
import net.java.dev.springannotation.annotation.Bean;
import net.java.dev.springannotation.annotation.Property;
import net.java.dev.springannotation.annotation.Scope;
import net.java.dev.springannotation.utils.IBeanReader;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReader
implements IBeanReader {
    @Override
    public void register(BeanDefinitionRegistry registry, Class<?> c) {
        Bean b = c.getAnnotation(Bean.class);
        Alias al = c.getAnnotation(Alias.class);
        RootBeanDefinition rbd = new RootBeanDefinition();
        rbd.setAbstract(false);
        rbd.setBeanClass(c);
        rbd.setSingleton(b.singleton());
        rbd.setLazyInit(b.lazy());
        if (!"".equals(b.initMethod().trim())) {
            rbd.setInitMethodName(b.initMethod());
        }
        if (!"".equals(b.destroyMethod().trim())) {
            rbd.setDestroyMethodName(b.destroyMethod());
        }
        if (!"".equals(b.factoryMethod().trim())) {
            rbd.setFactoryMethodName(b.factoryMethod());
        }
        rbd.setAutowireCandidate(true);
        rbd.setAutowireMode(b.autoWire().value());
        this.readProperties(c, b, rbd);
        if (!Scope.DEFAULT.equals((Object)b.scope())) {
            rbd.setScope(b.scope().getScopeName());
        } else if (!"".equals(b.scopeName().trim())) {
            rbd.setScope(b.scopeName());
        }
        String name = b.name();
        if (name == null || "".equals(name.trim())) {
            name = c.getName();
        }
        for (Method m : c.getMethods()) {
            if (m.getAnnotation(PreDestroy.class) != null) {
                rbd.setDestroyMethodName(m.getName());
            }
            if (m.getAnnotation(PostConstruct.class) == null) continue;
            rbd.setInitMethodName(m.getName());
        }
        registry.registerBeanDefinition(name, (BeanDefinition)rbd);
        if (al != null) {
            for (String alias : al.value()) {
                registry.registerAlias(name, alias);
            }
        }
    }

    private void readProperties(Class<?> c, Bean b, RootBeanDefinition rbd) {
        ArrayList fields = new ArrayList();
        for (Class<?> currentClass = c; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Collections.addAll(fields, currentClass.getDeclaredFields());
        }
        MutablePropertyValues mpv = new MutablePropertyValues();
        for (Field f : fields) {
            Property prop = f.getAnnotation(Property.class);
            if (prop == null) continue;
            if (!"".equals(prop.bean())) {
                mpv.addPropertyValue(f.getName(), (Object)new RuntimeBeanReference(prop.bean()));
                continue;
            }
            mpv.addPropertyValue(f.getName(), (Object)prop.value());
        }
        if (!mpv.isEmpty()) {
            rbd.setPropertyValues(mpv);
        }
    }
}

