/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.concurrent.Callable;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLIndexField;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.sql.SqlUtils;
import net.java.ao.test.DbUtils;
import net.java.ao.test.EntityUtils;
import net.java.ao.test.junit.ActiveObjectsJUnitRunner;
import org.junit.runner.RunWith;

@RunWith(value=ActiveObjectsJUnitRunner.class)
public abstract class ActiveObjectsIntegrationTest {
    protected EntityManager entityManager;

    protected final <T> T checkSqlExecuted(Callable<T> callable) throws Exception {
        return DbUtils.checkSqlExecuted(this.entityManager, callable);
    }

    protected final <T> T checkSqlNotExecuted(Callable<T> callable) throws Exception {
        return DbUtils.checkSqlNotExecuted(this.entityManager, callable);
    }

    protected final <E extends RawEntity<?>> E checkSqlExecutedWhenSaving(E entity) throws Exception {
        return DbUtils.checkSqlExecutedWhenSaving(this.entityManager, entity);
    }

    protected final void executeUpdate(String sql, DbUtils.UpdateCallback callback) throws Exception {
        DbUtils.executeUpdate(this.entityManager, sql, callback);
    }

    protected final void executeStatement(String sql, DbUtils.StatementCallback callback) throws Exception {
        DbUtils.executeStatement(this.entityManager, sql, callback);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType) {
        return EntityUtils.getTableName(this.entityManager, entityType);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType, boolean escape) {
        return EntityUtils.getTableName(this.entityManager, entityType, escape);
    }

    protected final String getFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.getFieldName(this.entityManager, entityType, methodName);
    }

    protected final String getPolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.getPolyFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapeFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapeFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapePolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapePolyFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapeKeyword(String keyword) {
        return EntityUtils.escapeKeyword(this.entityManager, keyword);
    }

    protected final DDLField findField(DDLTable table, String name) {
        for (DDLField field : table.getFields()) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            return field;
        }
        throw new IllegalStateException("Couldn't find field '" + name + "' in table '" + table.getName() + "'");
    }

    protected final DDLField findField(DDLTable table, Class<? extends RawEntity<?>> entityClass, String methodName) {
        return this.findField(table, this.getFieldName(entityClass, methodName));
    }

    protected DDLIndexField field(String name, Class type, Class<? extends RawEntity<?>> entity) {
        return DDLIndexField.builder().fieldName(this.getFieldName(entity, name)).type(this.entityManager.getProvider().getTypeManager().getType(type)).build();
    }

    protected String indexName(String tableName, String indexName) {
        IndexNameConverter indexNameConverter = this.entityManager.getNameConverters().getIndexNameConverter();
        DatabaseProvider provider = this.entityManager.getProvider();
        return indexNameConverter.getName(provider.shorten(tableName), provider.shorten(indexName));
    }

    protected SchemaConfiguration getSchemaConfiguration() {
        return (SchemaConfiguration)ActiveObjectsIntegrationTest.getFieldValue(this.entityManager, "schemaConfiguration");
    }

    protected static Object getFieldValue(Object target, String name) {
        try {
            Field field = ActiveObjectsIntegrationTest.findField(name, target.getClass());
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(String name, Class<?> targetClass) {
        return ActiveObjectsIntegrationTest.findField(name, targetClass, null);
    }

    private static Field findField(String name, Class<?> targetClass, Class<?> type) {
        for (Class<?> search = targetClass; !Object.class.equals(search) && search != null; search = search.getSuperclass()) {
            for (Field field : search.getDeclaredFields()) {
                if (!name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        throw new RuntimeException("No field with name '" + name + "' found in class hierarchy of '" + targetClass.getName() + "'");
    }

    protected void with(WithConnection w) throws Exception {
        Connection connection = null;
        try {
            connection = this.entityManager.getProvider().getConnection();
            w.call(connection);
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(connection);
            throw throwable;
        }
        SqlUtils.closeQuietly((Connection)connection);
    }

    static {
        System.setProperty("ao.atlassian.enforce.length", String.valueOf(false));
    }

    protected static interface WithConnection {
        public void call(Connection var1) throws Exception;
    }
}

