/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.Common;
import net.java.ao.RawEntity;
import net.java.ao.types.BigIntType;
import net.java.ao.types.BlobType;
import net.java.ao.types.BooleanType;
import net.java.ao.types.CharType;
import net.java.ao.types.ClobType;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.DateDateType;
import net.java.ao.types.DateType;
import net.java.ao.types.DoubleType;
import net.java.ao.types.EntityType;
import net.java.ao.types.EnumType;
import net.java.ao.types.FloatType;
import net.java.ao.types.GenericType;
import net.java.ao.types.IntegerType;
import net.java.ao.types.RealType;
import net.java.ao.types.TimestampDateType;
import net.java.ao.types.TimestampType;
import net.java.ao.types.TinyIntType;
import net.java.ao.types.URIType;
import net.java.ao.types.URLType;
import net.java.ao.types.VarcharType;

public class TypeManager {
    private static TypeManager instance;
    private final List<DatabaseType<?>> types = Collections.synchronizedList(new ArrayList());
    private final Map<Class<?>, DatabaseType<?>> classIndex = new HashMap();
    private final ReadWriteLock classIndexLock;
    private final Map<Integer, DatabaseType<?>> intIndex = new HashMap();
    private final ReadWriteLock intIndexLock;

    private TypeManager() {
        this.classIndexLock = new ReentrantReadWriteLock();
        this.intIndexLock = new ReentrantReadWriteLock();
        this.types.add(new BigIntType());
        this.types.add(new BooleanType());
        this.types.add(new BlobType());
        this.types.add(new CharType());
        this.types.add(new DoubleType());
        this.types.add(new FloatType());
        this.types.add(new IntegerType());
        this.types.add(new TimestampType());
        this.types.add(new TimestampDateType());
        this.types.add(new TinyIntType());
        this.types.add(new VarcharType());
        this.types.add(new ClobType());
        this.types.add(new DateType());
        this.types.add(new DateDateType());
        this.types.add(new EnumType());
        this.types.add(new RealType());
        this.types.add(new URLType());
        this.types.add(new URIType());
    }

    public void addType(DatabaseType<?> type) {
        this.types.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DatabaseType<T> getType(Class<T> javaType) {
        DatabaseType<T> back;
        block8: {
            back = null;
            if (Common.typeInstanceOf(javaType, RawEntity.class)) {
                return new EntityType(javaType);
            }
            this.classIndexLock.writeLock().lock();
            try {
                if (this.classIndex.containsKey(javaType)) {
                    DatabaseType<?> databaseType = this.classIndex.get(javaType);
                    return databaseType;
                }
                for (DatabaseType<T> databaseType : this.types) {
                    if (!databaseType.isHandlerFor(javaType)) continue;
                    back = databaseType;
                    break;
                }
                if (back != null) {
                    this.classIndex.put(javaType, back);
                    break block8;
                }
                throw new RuntimeException("Unrecognized type: " + javaType.getName());
            }
            finally {
                this.classIndexLock.writeLock().unlock();
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseType<?> getType(int sqlType) {
        DatabaseType back = null;
        this.intIndexLock.writeLock().lock();
        try {
            if (this.intIndex.containsKey(sqlType)) {
                DatabaseType<?> databaseType = this.intIndex.get(sqlType);
                return databaseType;
            }
            for (DatabaseType<?> type : this.types) {
                if (!type.isHandlerFor(sqlType)) continue;
                back = type;
                break;
            }
            if (back == null) {
                back = new GenericType(sqlType);
            }
            this.intIndex.put(sqlType, back);
        }
        finally {
            this.intIndexLock.writeLock().unlock();
        }
        return back;
    }

    public static synchronized TypeManager getInstance() {
        if (instance == null) {
            instance = new TypeManager();
        }
        return instance;
    }
}

