/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.SchemaGenerator;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.types.TypeManager;

public class Query
implements Serializable {
    private static final String PRIMARY_KEY_FIELD = "''''primary_key_field''''";
    private final QueryType type;
    private String fields;
    private boolean distinct = false;
    private Class<? extends RawEntity<?>> tableType;
    private String table;
    private String whereClause;
    private Object[] whereParams;
    private String orderClause;
    private String groupClause;
    private int limit = -1;
    private int offset = -1;
    private Map<Class<? extends RawEntity<?>>, String> joins;
    private static final long serialVersionUID = 1L;

    public Query(QueryType type, String fields) {
        this.type = type;
        this.fields = fields;
        this.joins = new LinkedHashMap();
    }

    public String[] getFields() {
        if (this.fields.contains(PRIMARY_KEY_FIELD)) {
            return new String[0];
        }
        String[] fieldsArray = this.fields.split(",");
        String[] back = new String[fieldsArray.length];
        for (int i = 0; i < fieldsArray.length; ++i) {
            back[i] = fieldsArray[i].trim();
        }
        return back;
    }

    void setFields(String[] fields) {
        if (fields.length == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String field : fields) {
            builder.append(field).append(',');
        }
        if (fields.length > 1) {
            builder.setLength(builder.length() - 1);
        }
        this.fields = builder.toString();
    }

    <K> void resolveFields(Class<? extends RawEntity<K>> tableType, FieldNameConverter converter) {
        this.fields = this.fields.replaceAll(PRIMARY_KEY_FIELD, Common.getPrimaryKeyField(tableType, converter));
    }

    public Query distinct() {
        this.distinct = true;
        return this;
    }

    public Query from(Class<? extends RawEntity<?>> tableType) {
        this.table = null;
        this.tableType = tableType;
        return this;
    }

    public Query from(String table) {
        this.tableType = null;
        this.table = table;
        return this;
    }

    public Query where(String clause, Object ... params) {
        this.whereClause = clause;
        this.setWhereParams(params);
        return this;
    }

    public Query order(String clause) {
        this.orderClause = clause;
        return this;
    }

    public Query group(String clause) {
        this.groupClause = clause;
        return this;
    }

    public Query limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Query join(Class<? extends RawEntity<?>> join, String on) {
        this.joins.put(join, on);
        return this;
    }

    public Query join(Class<? extends RawEntity<?>> join) {
        this.joins.put(join, null);
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Class<? extends RawEntity<?>> getTableType() {
        return this.tableType;
    }

    public void setTableType(Class<? extends RawEntity<?>> tableType) {
        this.tableType = tableType;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public Object[] getWhereParams() {
        return this.whereParams;
    }

    public void setWhereParams(Object[] whereParams) {
        this.whereParams = whereParams;
        if (whereParams != null) {
            for (int i = 0; i < whereParams.length; ++i) {
                if (!(whereParams[i] instanceof RawEntity)) continue;
                whereParams[i] = Common.getPrimaryKeyValue((RawEntity)whereParams[i]);
            }
        }
    }

    public String getOrderClause() {
        return this.orderClause;
    }

    public void setOrderClause(String orderClause) {
        this.orderClause = orderClause;
    }

    public String getGroupClause() {
        return this.groupClause;
    }

    public void setGroupClause(String groupClause) {
        this.groupClause = groupClause;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Map<Class<? extends RawEntity<?>>, String> getJoins() {
        return Collections.unmodifiableMap(this.joins);
    }

    public void setJoins(Map<Class<? extends RawEntity<?>>, String> joins) {
        this.joins = joins;
    }

    public QueryType getType() {
        return this.type;
    }

    public String[] getCanonicalFields(Class<? extends RawEntity<?>> type, FieldNameConverter converter) {
        String[] back = this.fields.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : back) {
            if (fieldName.trim().equals("*")) {
                for (DDLField field : SchemaGenerator.parseFields(type, converter)) {
                    result.add(field.getName());
                }
                continue;
            }
            result.add(fieldName.trim());
        }
        return result.toArray(new String[result.size()]);
    }

    protected <K> String toSQL(Class<? extends RawEntity<K>> tableType, DatabaseProvider provider, TableNameConverter converter, FieldNameConverter fieldConverter, boolean count) {
        if (this.tableType == null && this.table == null) {
            this.tableType = tableType;
        }
        this.resolveFields(tableType, fieldConverter);
        return provider.renderQuery(this, converter, count);
    }

    protected void setParameters(EntityManager manager, PreparedStatement stmt) throws SQLException {
        if (this.whereParams != null) {
            TypeManager typeManager = TypeManager.getInstance();
            for (int i = 0; i < this.whereParams.length; ++i) {
                if (this.whereParams[i] == null) {
                    manager.getProvider().putNull(stmt, i + 1);
                    continue;
                }
                Class<Object> javaType = this.whereParams[i].getClass();
                if (this.whereParams[i] instanceof RawEntity) {
                    javaType = ((RawEntity)this.whereParams[i]).getEntityType();
                }
                typeManager.getType(javaType).putToDatabase(manager, stmt, i + 1, this.whereParams[i]);
            }
        }
    }

    public static Query select() {
        return Query.select(PRIMARY_KEY_FIELD);
    }

    public static Query select(String fields) {
        return new Query(QueryType.SELECT, fields);
    }

    public static enum QueryType {
        SELECT;

    }
}

