/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import net.java.ao.schema.FieldNameConverter;

final class MethodFinder {
    private final Map<AnnotatedMethods, Iterable<Method>> annotatedMethodsCache = new MapMaker().weakKeys().weakValues().makeComputingMap((Function)new Function<AnnotatedMethods, Iterable<Method>>(){

        public Iterable<Method> apply(AnnotatedMethods a) {
            return a.getAnnotatedMethods();
        }
    });
    private final Map<CounterPartMethod, Supplier<Method>> counterpartCache = new MapMaker().weakKeys().weakValues().makeComputingMap((Function)new Function<CounterPartMethod, Supplier<Method>>(){

        public Supplier<Method> apply(CounterPartMethod c) {
            return Suppliers.ofInstance((Object)c.getCounterPartMethod());
        }
    });
    private static final Supplier<MethodFinder> INSTANCE_SUPPLIER = Suppliers.synchronizedSupplier((Supplier)Suppliers.memoize((Supplier)new Supplier<MethodFinder>(){

        public MethodFinder get() {
            return new MethodFinder();
        }
    }));

    MethodFinder() {
    }

    public Iterable<Method> findAnnotatedMethods(Class<? extends Annotation> annotation, Class<?> type) {
        return this.annotatedMethodsCache.get(new AnnotatedMethods(annotation, type));
    }

    public Method findCounterPartMethod(FieldNameConverter converter, Method method) {
        return (Method)this.counterpartCache.get(new CounterPartMethod(converter, method)).get();
    }

    public static MethodFinder getInstance() {
        return (MethodFinder)INSTANCE_SUPPLIER.get();
    }

    private static final class CounterPartMethod {
        private final FieldNameConverter converter;
        private final Method method;

        CounterPartMethod(FieldNameConverter converter, Method method) {
            this.converter = converter;
            this.method = method;
        }

        Method getCounterPartMethod() {
            String name = this.converter.getName(this.method);
            Class<?> clazz = this.method.getDeclaringClass();
            for (Method other : clazz.getMethods()) {
                String otherName = this.converter.getName(other);
                if (other.equals(this.method) || otherName == null || !otherName.equals(name)) continue;
                return other;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterPartMethod that = (CounterPartMethod)o;
            if (this.converter != null ? !this.converter.equals(that.converter) : that.converter != null) {
                return false;
            }
            return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
        }

        public int hashCode() {
            int result = this.converter != null ? this.converter.hashCode() : 0;
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            return result;
        }
    }

    private static final class AnnotatedMethods {
        private final Class<? extends Annotation> annotation;
        private final Class<?> type;

        AnnotatedMethods(Class<? extends Annotation> annotation, Class<?> type) {
            this.annotation = (Class)Preconditions.checkNotNull(annotation);
            this.type = (Class)Preconditions.checkNotNull(type);
        }

        Iterable<Method> getAnnotatedMethods() {
            ImmutableList.Builder annotatedMethods = ImmutableList.builder();
            for (Method m : this.type.getMethods()) {
                if (!m.isAnnotationPresent(this.annotation)) continue;
                annotatedMethods.add((Object)m);
            }
            return annotatedMethods.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotatedMethods that = (AnnotatedMethods)o;
            if (this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.annotation != null ? this.annotation.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

