/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DefaultPolymorphicTypeMapper;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.EntityProxy;
import net.java.ao.EntityProxyAccessor;
import net.java.ao.Generator;
import net.java.ao.LRUMap;
import net.java.ao.MethodFinder;
import net.java.ao.PolymorphicTypeMapper;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.SchemaConfiguration;
import net.java.ao.ValueGenerator;
import net.java.ao.cache.Cache;
import net.java.ao.cache.CacheLayer;
import net.java.ao.cache.RAMCache;
import net.java.ao.cache.RAMRelationsCache;
import net.java.ao.cache.RelationsCache;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.CachingTableNameConverter;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.SchemaGenerator;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;

public class EntityManager {
    private final DatabaseProvider provider;
    private final EntityManagerConfiguration configuration;
    private final TableNameConverter tableNameConverter;
    private final FieldNameConverter fieldNameConverter;
    private final SchemaConfiguration schemaConfiguration;
    private Map<RawEntity<?>, EntityProxy<? extends RawEntity<?>, ?>> proxies;
    private final ReadWriteLock proxyLock = new ReentrantReadWriteLock(true);
    private Map<CacheKey<?>, Reference<RawEntity<?>>> entityCache;
    private final ReadWriteLock entityCacheLock = new ReentrantReadWriteLock(true);
    private Cache cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private PolymorphicTypeMapper typeMapper;
    private final ReadWriteLock typeMapperLock = new ReentrantReadWriteLock(true);
    private Map<Class<? extends ValueGenerator<?>>, ValueGenerator<?>> valGenCache;
    private final ReadWriteLock valGenCacheLock = new ReentrantReadWriteLock(true);
    private final RelationsCache relationsCache = new RAMRelationsCache();

    public EntityManager(DatabaseProvider provider, EntityManagerConfiguration configuration) {
        this.provider = (DatabaseProvider)Preconditions.checkNotNull((Object)provider);
        this.configuration = (EntityManagerConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.proxies = configuration.useWeakCache() ? new MapMaker().weakKeys().makeMap() : new MapMaker().softKeys().makeMap();
        this.entityCache = new LRUMap(500);
        this.cache = new RAMCache();
        this.valGenCache = new HashMap();
        this.tableNameConverter = new CachingTableNameConverter((TableNameConverter)Preconditions.checkNotNull((Object)configuration.getTableNameConverter()));
        this.fieldNameConverter = (FieldNameConverter)Preconditions.checkNotNull((Object)configuration.getFieldNameConverter());
        this.schemaConfiguration = (SchemaConfiguration)Preconditions.checkNotNull((Object)configuration.getSchemaConfiguration());
        this.typeMapper = new DefaultPolymorphicTypeMapper(new HashMap());
    }

    public void migrate(Class<? extends RawEntity<?>> ... entities) throws SQLException {
        SchemaGenerator.migrate(this.provider, this.schemaConfiguration, this.tableNameConverter, this.fieldNameConverter, entities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        LinkedList toFlush = new LinkedList();
        this.proxyLock.readLock().lock();
        try {
            for (Map.Entry<RawEntity<?>, EntityProxy<? extends RawEntity<?>, ?>> entry : this.proxies.entrySet()) {
                toFlush.add(entry);
            }
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
        for (Map.Entry<RawEntity<Object>, EntityProxy<RawEntity<Object>, Object>> entry : toFlush) {
            entry.getValue().flushCache(entry.getKey());
        }
        this.relationsCache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RawEntity<?> ... entities) {
        ArrayList types = new ArrayList(entities.length);
        HashMap toFlush = new HashMap();
        this.proxyLock.readLock().lock();
        try {
            for (RawEntity<?> entity : entities) {
                this.verify(entity);
                types.add(entity.getEntityType());
                toFlush.put(entity, this.proxies.get(entity));
            }
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
        for (Map.Entry entry : toFlush.entrySet()) {
            ((EntityProxy)entry.getValue()).flushCache((RawEntity)entry.getKey());
        }
        this.relationsCache.remove(types.toArray(new Class[types.size()]));
    }

    public <T extends RawEntity<K>, K> T[] get(final Class<T> type, K ... keys) {
        final String primaryKeyField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        final String tableName = this.getTableNameConverter().getName(type);
        return this.getFromCache(type, new Function<T, K>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T invoke(K key) {
                Object back = null;
                Connection conn = null;
                try {
                    conn = EntityManager.this.provider.getConnection();
                    StringBuilder sql = new StringBuilder("SELECT ");
                    sql.append(EntityManager.this.provider.processID(primaryKeyField));
                    sql.append(" FROM ").append(EntityManager.this.provider.processID(tableName));
                    sql.append(" WHERE ").append(EntityManager.this.provider.processID(primaryKeyField));
                    sql.append(" = ?");
                    PreparedStatement stmt = conn.prepareStatement(sql.toString());
                    DatabaseType<?> dbType = TypeManager.getInstance().getType(key.getClass());
                    dbType.putToDatabase(EntityManager.this, stmt, 1, key);
                    ResultSet res = stmt.executeQuery();
                    if (res.next()) {
                        back = EntityManager.this.getAndInstantiate(type, key);
                    }
                    res.close();
                    stmt.close();
                }
                catch (SQLException e) {
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {}
                    }
                }
                return back;
            }
        }, keys);
    }

    protected <T extends RawEntity<K>, K> T[] peer(final Class<T> type, K ... keys) {
        return this.getFromCache(type, new Function<T, K>(){

            @Override
            public T invoke(K key) {
                return EntityManager.this.getAndInstantiate(type, key);
            }
        }, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends RawEntity<K>, K> T[] getFromCache(Class<T> type, Function<T, K> create, K ... keys) {
        RawEntity[] back = (RawEntity[])Array.newInstance(type, keys.length);
        int index = 0;
        for (K key : keys) {
            this.entityCacheLock.writeLock().lock();
            try {
                RawEntity<?> entity;
                Reference<RawEntity<?>> reference;
                Reference<RawEntity<?>> ref = reference = this.entityCache.get(new CacheKey<K>(key, type));
                RawEntity<?> rawEntity = entity = ref == null ? null : ref.get();
                if (entity != null) {
                    back[index++] = entity;
                    continue;
                }
                back[index++] = (RawEntity)create.invoke(key);
            }
            finally {
                this.entityCacheLock.writeLock().unlock();
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends RawEntity<K>, K> T getAndInstantiate(Class<T> type, K key) {
        EntityProxy<T, K> proxy = new EntityProxy<T, K>(this, type, key);
        RawEntity entity = (RawEntity)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, EntityProxyAccessor.class}, proxy));
        this.proxyLock.writeLock().lock();
        try {
            this.proxies.put(entity, proxy);
        }
        finally {
            this.proxyLock.writeLock().unlock();
        }
        this.entityCache.put(new CacheKey<K>(key, type), this.createRef(entity));
        return (T)entity;
    }

    public <T extends RawEntity<K>, K> T get(Class<T> type, K key) {
        return this.get(type, (K)EntityManager.toArray(key))[0];
    }

    protected <T extends RawEntity<K>, K> T peer(Class<T> type, K key) {
        return this.peer(type, (K)EntityManager.toArray(key))[0];
    }

    private static <K> K[] toArray(K key) {
        return new Object[]{key};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) throws SQLException {
        RawEntity back = null;
        String table = this.tableNameConverter.getName(type);
        HashSet<DBParam> listParams = new HashSet<DBParam>();
        listParams.addAll(Arrays.asList(params));
        for (Method method : MethodFinder.getInstance().findAnnotatedMethods(Generator.class, type)) {
            ValueGenerator<?> generator;
            Generator genAnno = method.getAnnotation(Generator.class);
            String field = this.fieldNameConverter.getName(method);
            this.valGenCacheLock.writeLock().lock();
            try {
                if (this.valGenCache.containsKey(genAnno.value())) {
                    generator = this.valGenCache.get(genAnno.value());
                } else {
                    generator = genAnno.value().newInstance();
                    this.valGenCache.put(genAnno.value(), generator);
                }
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            finally {
                this.valGenCacheLock.writeLock().unlock();
                continue;
            }
            listParams.add(new DBParam(field, generator.generateValue(this)));
        }
        Connection conn = this.provider.getConnection();
        try {
            Method pkMethod = Common.getPrimaryKeyMethod(type);
            back = (RawEntity)this.peer(type, (K)this.provider.insertReturningKey(this, conn, Common.getPrimaryKeyClassType(type), Common.getPrimaryKeyField(type, this.getFieldNameConverter()), pkMethod.getAnnotation(AutoIncrement.class) != null, table, listParams.toArray(new DBParam[listParams.size()])));
        }
        finally {
            conn.close();
        }
        this.relationsCache.remove(type);
        back.init();
        return (T)back;
    }

    public <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) throws SQLException {
        DBParam[] arrParams = new DBParam[params.size()];
        int i = 0;
        for (String key : params.keySet()) {
            arrParams[i++] = new DBParam(key, params.get(key));
        }
        return this.create(type, arrParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RawEntity<?> ... entities) throws SQLException {
        if (entities.length == 0) {
            return;
        }
        HashMap organizedEntities = new HashMap();
        for (RawEntity<?> entity : entities) {
            this.verify(entity);
            Class<RawEntity<?>> type = this.getProxyForEntity(entity).getType();
            if (!organizedEntities.containsKey(type)) {
                organizedEntities.put(type, new LinkedList());
            }
            ((List)organizedEntities.get(type)).add(entity);
        }
        this.entityCacheLock.writeLock().lock();
        try {
            Connection conn = this.provider.getConnection();
            try {
                for (Class type : organizedEntities.keySet()) {
                    List entityList = (List)organizedEntities.get(type);
                    StringBuilder sql = new StringBuilder("DELETE FROM ");
                    sql.append(this.provider.processID(this.tableNameConverter.getName(type)));
                    sql.append(" WHERE ").append(this.provider.processID(Common.getPrimaryKeyField(type, this.getFieldNameConverter()))).append(" IN (?");
                    for (int i = 1; i < entityList.size(); ++i) {
                        sql.append(",?");
                    }
                    sql.append(')');
                    PreparedStatement stmt = this.provider.preparedStatement(conn, sql);
                    int index = 1;
                    for (RawEntity entity : entityList) {
                        TypeManager.getInstance().getType(entity.getEntityType()).putToDatabase(this, stmt, index++, entity);
                    }
                    this.relationsCache.remove(type);
                    stmt.executeUpdate();
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
            for (RawEntity<?> entity : entities) {
                this.entityCache.remove(new CacheKey(Common.getPrimaryKeyValue(entity), entity.getEntityType()));
            }
            this.proxyLock.writeLock().lock();
            try {
                for (RawEntity<?> entity : entities) {
                    this.proxies.remove(entity);
                }
            }
            finally {
                this.proxyLock.writeLock().unlock();
            }
        }
        finally {
            this.entityCacheLock.writeLock().unlock();
        }
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type) throws SQLException {
        return this.find(type, Query.select());
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        return this.find(type, Query.select().where(criteria, parameters));
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) throws SQLException {
        String selectField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        query.resolveFields(type, this.getFieldNameConverter());
        String[] fields = query.getFields();
        if (fields.length == 1) {
            selectField = fields[0];
        }
        return this.find(type, selectField, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        query.resolveFields(type, this.getFieldNameConverter());
        Preload preloadAnnotation = type.getAnnotation(Preload.class);
        if (preloadAnnotation != null && !query.getFields()[0].equals("*") && query.getJoins().isEmpty()) {
            String[] oldFields = query.getFields();
            ArrayList<String> newFields = new ArrayList<String>();
            for (String newField : Common.preloadValue(preloadAnnotation, this.fieldNameConverter)) {
                newField = newField.trim();
                int fieldLoc = -1;
                for (int i = 0; i < oldFields.length; ++i) {
                    if (!oldFields[i].equals(newField)) continue;
                    fieldLoc = i;
                    break;
                }
                if (fieldLoc < 0) {
                    newFields.add(newField);
                    continue;
                }
                newFields.add(oldFields[fieldLoc]);
            }
            if (!newFields.contains("*")) {
                for (String oldField : oldFields) {
                    if (newFields.contains(oldField)) continue;
                    newFields.add(oldField);
                }
            }
            query.setFields(newFields.toArray(new String[newFields.size()]));
        }
        Connection conn = this.provider.getConnection();
        try {
            String sql = query.toSQL(type, this.provider, this.tableNameConverter, this.getFieldNameConverter(), false);
            PreparedStatement stmt = this.provider.preparedStatement(conn, sql, 1004, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            ResultSet res = stmt.executeQuery();
            this.provider.setQueryResultSetProperties(res, query);
            DatabaseType primaryKeyType = Common.getPrimaryKeyType(type);
            Class primaryKeyClassType = Common.getPrimaryKeyClassType(type);
            String[] canonicalFields = query.getCanonicalFields(type, this.fieldNameConverter);
            while (res.next()) {
                T entity = this.peer(type, (K)primaryKeyType.pullFromDatabase(this, res, primaryKeyClassType, field));
                CacheLayer cacheLayer = this.getProxyForEntity(entity).getCacheLayer((RawEntity<?>)entity);
                for (String cacheField : canonicalFields) {
                    cacheLayer.put(cacheField, res.getObject(cacheField));
                }
                back.add(entity);
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        Connection conn = this.provider.getConnection();
        try {
            PreparedStatement stmt = this.provider.preparedStatement(conn, sql);
            TypeManager manager = TypeManager.getInstance();
            for (int i = 0; i < parameters.length; ++i) {
                Class<Object> javaType = parameters[i].getClass();
                if (parameters[i] instanceof RawEntity) {
                    javaType = ((RawEntity)parameters[i]).getEntityType();
                }
                manager.getType(javaType).putToDatabase(this, stmt, i + 1, parameters[i]);
            }
            ResultSet res = stmt.executeQuery();
            while (res.next()) {
                back.add(this.peer(type, (K)Common.getPrimaryKeyType(type).pullFromDatabase(this, res, type, keyField)));
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    public <K> int count(Class<? extends RawEntity<K>> type) throws SQLException {
        return this.count(type, Query.select());
    }

    public <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) throws SQLException {
        return this.count(type, Query.select().where(criteria, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> int count(Class<? extends RawEntity<K>> type, Query query) throws SQLException {
        int back = -1;
        Connection conn = this.provider.getConnection();
        try {
            String sql = query.toSQL(type, this.provider, this.tableNameConverter, this.getFieldNameConverter(), true);
            PreparedStatement stmt = this.provider.preparedStatement(conn, sql);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            ResultSet res = stmt.executeQuery();
            if (res.next()) {
                back = res.getInt(1);
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back;
    }

    public TableNameConverter getTableNameConverter() {
        return this.tableNameConverter;
    }

    public FieldNameConverter getFieldNameConverter() {
        return this.fieldNameConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolymorphicTypeMapper(PolymorphicTypeMapper typeMapper) {
        this.typeMapperLock.writeLock().lock();
        try {
            this.typeMapper = typeMapper;
            if (typeMapper instanceof DefaultPolymorphicTypeMapper) {
                ((DefaultPolymorphicTypeMapper)typeMapper).resolveMappings(this.getTableNameConverter());
            }
        }
        finally {
            this.typeMapperLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolymorphicTypeMapper getPolymorphicTypeMapper() {
        this.typeMapperLock.readLock().lock();
        try {
            if (this.typeMapper == null) {
                throw new RuntimeException("No polymorphic type mapper was specified");
            }
            PolymorphicTypeMapper polymorphicTypeMapper = this.typeMapper;
            return polymorphicTypeMapper;
        }
        finally {
            this.typeMapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Cache cache) {
        this.cacheLock.writeLock().lock();
        try {
            if (!this.cache.equals(cache)) {
                this.cache.dispose();
                this.cache = cache;
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.cacheLock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public DatabaseProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends RawEntity<K>, K> EntityProxy<T, K> getProxyForEntity(T entity) {
        this.proxyLock.readLock().lock();
        try {
            EntityProxy entityProxy = ((EntityProxyAccessor)((Object)entity)).getEntityProxy();
            return entityProxy;
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
    }

    RelationsCache getRelationsCache() {
        return this.relationsCache;
    }

    private Reference<RawEntity<?>> createRef(RawEntity<?> entity) {
        if (this.configuration.useWeakCache()) {
            return new WeakReference(entity);
        }
        return new SoftReference(entity);
    }

    private void verify(RawEntity<?> entity) {
        if (entity.getEntityManager() != this) {
            throw new RuntimeException("Entities can only be used with a single EntityManager instance");
        }
    }

    private static class CacheKey<T> {
        private T key;
        private Class<? extends RawEntity<?>> type;

        public CacheKey(T key, Class<? extends RawEntity<T>> type) {
            this.key = key;
            this.type = type;
        }

        public int hashCode() {
            return (this.type.hashCode() + this.key.hashCode()) % 65536;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey keyObj = (CacheKey)obj;
                if (this.key.equals(keyObj.key) && this.type.equals(keyObj.type)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static interface Function<R, F> {
        public R invoke(F var1);
    }
}

