/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema.task;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.ao.schema.task.EntityType;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class MigrateTask
extends Task {
    private String[] classpath;
    private String uri;
    private String username;
    private String password;
    private String nameConverter;
    private List<EntityType> entities = new ArrayList<EntityType>();

    public void execute() {
        try {
            System.out.println("Migrating schema to match entity definition...");
            URL[] urls = new URL[this.classpath.length];
            for (int i = 0; i < this.classpath.length; ++i) {
                String cp = this.classpath[i];
                cp = cp.replace('\\', '/');
                if (Pattern.compile("^[A-Z]:").matcher(cp).find()) {
                    cp = "/" + cp;
                }
                urls[i] = new URL("file://" + cp);
            }
            URLClassLoader classloader = new URLClassLoader(urls);
            Class<?> emClass = Class.forName("net.java.ao.EntityManager", true, classloader);
            Object manager = emClass.getConstructor(String.class, String.class, String.class).newInstance(this.uri, this.username, this.password);
            emClass.getMethod("setNameConverter", Class.forName("net.java.ao.schema.PluggableNameConverter", true, classloader)).invoke(manager, this.loadNameConverter(classloader));
            emClass.getMethod("migrate", Class[].class).invoke(manager, new Object[]{this.loadClasses(classloader)});
            Object provider = emClass.getMethod("getProvider", new Class[0]).invoke(manager, new Object[0]);
            provider.getClass().getMethod("dispose", new Class[0]).invoke(provider, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Object loadNameConverter(ClassLoader classloader) {
        if (this.nameConverter != null && this.nameConverter.split(".").length == 0) {
            this.nameConverter = "net.java.ao.schema." + this.nameConverter;
        }
        Class<?> converterClass = null;
        try {
            converterClass = Class.forName(this.nameConverter, true, classloader);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (converterClass == null) {
            throw new IllegalArgumentException("Unable to locate table name converter");
        }
        Object back = null;
        try {
            back = converterClass.newInstance();
        }
        catch (Throwable t) {
            System.err.println("Unable to load \"" + this.nameConverter + '\"');
            System.err.println("Using default name converter...");
            try {
                back = Class.forName("net.java.ao.schema.CamelCaseNameConverter", true, classloader).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return back;
    }

    private Class<?>[] loadClasses(ClassLoader classloader) throws MalformedURLException, ClassNotFoundException {
        Class[] back = new Class[this.entities.size()];
        for (int i = 0; i < back.length; ++i) {
            back[i] = Class.forName(this.entities.get(i).getText(), true, classloader);
        }
        return back;
    }

    public void setClasspath(String path) throws IOException {
        String[] paths = path.split(File.pathSeparator);
        this.classpath = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            this.classpath[i] = file.getCanonicalPath().replace('\\', '/');
            if (!file.isDirectory()) continue;
            int n = i;
            this.classpath[n] = this.classpath[n] + '/';
        }
    }

    public void setClasspathRef(String reference) {
        Path path = (Path)this.getProject().getReference(reference);
        this.classpath = path.list();
        for (int i = 0; i < this.classpath.length; ++i) {
            if (!new File(this.classpath[i]).isDirectory()) continue;
            int n = i;
            this.classpath[n] = this.classpath[n] + '/';
        }
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNameConverter(String nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void addEntity(EntityType entity) {
        this.entities.add(entity);
    }
}

